/// <reference path="./internal_*.d.ts" />
declare namespace Internal {
    class StructureStart {
        constructor($$0: Internal.Structure_, $$1: Internal.ChunkPos_, $$2: number, $$3: Internal.PiecesContainer_)
        canBeReferenced(): boolean;
        isValid(): boolean;
        getChunkPos(): Internal.ChunkPos;
        getPieces(): Internal.List<Internal.StructurePiece>;
        getStructure(): Internal.Structure;
        getReferences(): number;
        placeInChunk($$0: Internal.WorldGenLevel_, $$1: Internal.StructureManager_, $$2: Internal.ChunkGenerator_, $$3: Internal.RandomSource_, $$4: Internal.BoundingBox_, $$5: Internal.ChunkPos_): void;
        getBoundingBox(): Internal.BoundingBox;
        addReference(): void;
        createTag($$0: Internal.StructurePieceSerializationContext_, $$1: Internal.ChunkPos_): Internal.CompoundTag;
        static loadStaticStart($$0: Internal.StructurePieceSerializationContext_, $$1: Internal.CompoundTag_, $$2: number): Internal.StructureStart;
        get valid(): boolean
        get chunkPos(): Internal.ChunkPos
        get pieces(): Internal.List<Internal.StructurePiece>
        get structure(): Internal.Structure
        get references(): number
        get boundingBox(): Internal.BoundingBox
        static readonly INVALID_START_ID: "INVALID";
        static readonly INVALID_START: Internal.StructureStart;
    }
    type StructureStart_ = StructureStart;
    class ThermalCalciteBlock extends Internal.Block {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        static getOptionalDistanceAt(p_277868_: Internal.BlockState_): Internal.OptionalInt;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly DISTANCE: Internal.IntegerProperty;
    }
    type ThermalCalciteBlock_ = ThermalCalciteBlock;
    class ConsoleLine {
        constructor(buf: Internal.FriendlyByteBuf_)
        constructor(console: Internal.ConsoleJS_, timestamp: number, message: string)
        withSourceLine(source: string, line: number): this;
        getText(): string;
        static writeToNet(buf: Internal.FriendlyByteBuf_, line: Internal.ConsoleLine_): void;
        withExternalFile(path: Internal.Path_): this;
        get text(): string
        type: Internal.LogType;
        externalFile: Internal.Path;
        readonly console: Internal.ConsoleJS;
        readonly timestamp: number;
        group: string;
        sourceLines: Internal.Collection<Internal.ConsoleLine$SourceLine>;
        static readonly EMPTY_ARRAY: Internal.ConsoleLine[];
        message: string;
        stackTrace: Internal.List<string>;
    }
    type ConsoleLine_ = ConsoleLine;
    interface RecipeFilterParseEvent {
        abstract parse(arg0: Internal.Context_, arg1: Internal.List_<Internal.RecipeFilter>, arg2: Internal.Map_<any, any>): void;
        (arg0: Internal.Context, arg1: Internal.List<Internal.RecipeFilter>, arg2: Internal.Map<any, any>): void;
    }
    type RecipeFilterParseEvent_ = RecipeFilterParseEvent;
    class MoltenBismuthFluid$Source extends Internal.MoltenBismuthFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenBismuthFluid$Source_ = MoltenBismuthFluid$Source;
    interface Object2LongMap$Entry <K> extends Internal.Map$Entry<K, number> {
        abstract getKey(): K;
        /**
         * @deprecated
        */
        setValue(arg0: number): number;
        comparingByKey<K, V>(arg0: Internal.Comparator_<K>): Internal.Comparator<Internal.Map$Entry<K, V>>;
        /**
         * @deprecated
        */
        getValue(): number;
        /**
         * @deprecated
        */
        setValue(arg0: any): any;
        comparingByValue<K, V extends Internal.Comparable<any>>(): Internal.Comparator<Internal.Map$Entry<K, V>>;
        abstract hashCode(): number;
        copyOf<K, V>(arg0: Internal.Map$Entry_<K, V>): Internal.Map$Entry<K, V>;
        abstract setValue(arg0: number): number;
        comparingByKey<K extends Internal.Comparable<any>, V>(): Internal.Comparator<Internal.Map$Entry<K, V>>;
        comparingByValue<K, V>(arg0: Internal.Comparator_<V>): Internal.Comparator<Internal.Map$Entry<K, V>>;
        abstract getLongValue(): number;
        abstract equals(arg0: any): boolean;
        get key(): K
        /**
         * @deprecated
        */
        set value(arg0: number)
        /**
         * @deprecated
        */
        get value(): number
        /**
         * @deprecated
        */
        set value(arg0: any)
        set value(arg0: number)
        get longValue(): number
    }
    type Object2LongMap$Entry_<K> = Object2LongMap$Entry<K>;
    class DepositFilterType extends Internal.Enum<Internal.DepositFilterType> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        next(): this;
        getSerializedName(): string;
        static fromName(name: string): Internal.DepositFilterType;
        static valueOf(name: string): Internal.DepositFilterType;
        static values(): Internal.DepositFilterType[];
        get serializedName(): string
        static readonly INVENTORY: Internal.DepositFilterType;
        static readonly BLOCK: Internal.DepositFilterType;
        static readonly ALLOW: Internal.DepositFilterType;
    }
    type DepositFilterType_ = "block" | "allow" | "inventory" | DepositFilterType;
    class MageBlock$Companion {
        constructor($constructor_marker: any_)
        tick(world: Internal.Level_, position: BlockPos_, state: Internal.BlockState_, blockEntity: Internal.MageBlockEntity_): void;
    }
    type MageBlock$Companion_ = MageBlock$Companion;
    class PigmentIota extends Internal.Iota {
        constructor(pigment: Internal.FrozenPigment_)
        static access$setTYPE$cp(<set-?>: Internal.IotaType_<any>): void;
        static access$getTYPE$cp(): Internal.IotaType<any>;
        getPigment(): Internal.FrozenPigment;
        get pigment(): Internal.FrozenPigment
        static readonly Companion: Internal.PigmentIota$Companion;
    }
    type PigmentIota_ = PigmentIota;
    class PlayerEvents$PickupXp extends Internal.PlayerEvents {
        constructor(player: Internal.Player_, orb: Internal.ExperienceOrb_)
        getEntity(): Internal.LivingEntity;
        getOrb(): Internal.ExperienceOrb;
        get entity(): Internal.LivingEntity
        get orb(): Internal.ExperienceOrb
    }
    type PlayerEvents$PickupXp_ = PlayerEvents$PickupXp;
    class WitherSkeleton extends Internal.AbstractSkeleton {
        constructor($$0: Internal.EntityType_<Internal.WitherSkeleton>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type WitherSkeleton_ = WitherSkeleton;
    class ToggleLatchBlock extends Internal.AbstractDiodeBlock implements Internal.ConnectableRedstoneBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        canConnectRedstone(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, side: Internal.Direction_): boolean;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static POWERING: Internal.BooleanProperty;
    }
    type ToggleLatchBlock_ = ToggleLatchBlock;
    interface Long2CharFunction extends it.unimi.dsi.fastutil.Function<number, string>, Internal.LongToIntFunction {
        abstract get(arg0: number): string;
        composeDouble(arg0: Internal.Double2LongFunction_): Internal.Double2CharFunction;
        andThenReference<T>(arg0: Internal.Char2ReferenceFunction_<T>): Internal.Long2ReferenceFunction<T>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: string): string;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        andThenChar(arg0: Internal.Char2CharFunction_): this;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, string>;
        andThenByte(arg0: Internal.Char2ByteFunction_): Internal.Long2ByteFunction;
        defaultReturnValue(): string;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: string): string;
        getOrDefault(arg0: number, arg1: string): string;
        andThenShort(arg0: Internal.Char2ShortFunction_): Internal.Long2ShortFunction;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        composeInt(arg0: Internal.Int2LongFunction_): Internal.Int2CharFunction;
        andThenLong(arg0: Internal.Char2LongFunction_): Internal.Long2LongFunction;
        defaultReturnValue(arg0: string): void;
        remove(arg0: number): string;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        applyAsInt(arg0: number): number;
        composeChar(arg0: Internal.Char2LongFunction_): Internal.Char2CharFunction;
        composeByte(arg0: Internal.Byte2LongFunction_): Internal.Byte2CharFunction;
        composeLong(arg0: Internal.Long2LongFunction_): this;
        andThenObject<T>(arg0: Internal.Char2ObjectFunction_<T>): Internal.Long2ObjectFunction<T>;
        containsKey(arg0: number): boolean;
        andThenDouble(arg0: Internal.Char2DoubleFunction_): Internal.Long2DoubleFunction;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<string, T>): Internal.Function<number, T>;
        composeObject<T>(arg0: Internal.Object2LongFunction_<T>): Internal.Object2CharFunction<T>;
        apply(arg0: number): string;
        size(): number;
        andThenInt(arg0: Internal.Char2IntFunction_): Internal.Long2IntFunction;
        composeReference<T>(arg0: Internal.Reference2LongFunction_<T>): Internal.Reference2CharFunction<T>;
        composeFloat(arg0: Internal.Float2LongFunction_): Internal.Float2CharFunction;
        clear(): void;
        put(arg0: number, arg1: string): string;
        andThenFloat(arg0: Internal.Char2FloatFunction_): Internal.Long2FloatFunction;
        composeShort(arg0: Internal.Short2LongFunction_): Internal.Short2CharFunction;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        identity<T>(): Internal.Function<T, T>;
        (arg0: number): string;
    }
    type Long2CharFunction_ = Long2CharFunction;
    class StatsNBT$Builder {
        build(): Internal.StatsNBT;
        set<T>(stat: Internal.IToolStat_<T>, value: T): this;
    }
    type StatsNBT$Builder_ = StatsNBT$Builder;
    class BlastFurnaceMenu extends Internal.AbstractFurnaceMenu {
        constructor($$0: number, $$1: Internal.Inventory_, $$2: net.minecraft.world.Container_, $$3: Internal.ContainerData_)
        constructor($$0: number, $$1: Internal.Inventory_)
    }
    type BlastFurnaceMenu_ = BlastFurnaceMenu;
    class CopperCanItem extends Internal.Item {
        constructor(properties: Internal.Item$Properties_)
        static getFluid(nbt: Internal.CompoundTag_): Internal.Fluid;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        static getSubtype(stack: Internal.ItemStack_): string;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        static getFluidTag(nbt: Internal.CompoundTag_): Internal.CompoundTag;
        emi(amount: number): Internal.EmiStack;
        static setFluid(stack: Internal.ItemStack_, fluid: Internal.FluidStack_): Internal.ItemStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type CopperCanItem_ = CopperCanItem;
    interface SuggestionProvider <S> {
        abstract getSuggestions(arg0: Internal.CommandContext_<S>, arg1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        (arg0: Internal.CommandContext<S>, arg1: Internal.SuggestionsBuilder): Internal.CompletableFuture_<Internal.Suggestions>;
    }
    type SuggestionProvider_<S> = SuggestionProvider<S>;
    class RootedDirtBlock extends Internal.Block implements Internal.BonemealableBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        isBonemealSuccess($$0: Internal.Level_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        performBonemeal($$0: Internal.ServerLevel_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type RootedDirtBlock_ = RootedDirtBlock;
    class FilterItemStackHandler extends io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler {
        constructor(size: number)
        supportsInsertion(): boolean;
        isItemValid(slot: number, resource: Internal.ItemVariant_, count: number): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        isItemValid(slot: number, resource: Internal.ItemVariant_): boolean;
        static asClass<T>(): Internal.Storage<T>;
        supportsExtraction(): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateInsert(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        forEach(arg0: Internal.Consumer_<Internal.StorageView<T>>): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateExtract(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        serializeNBT(): Internal.Tag;
        getVersion(): number;
        spliterator(): Internal.Spliterator<Internal.StorageView<T>>;
        iterator(): Internal.Iterator<Internal.StorageView<Internal.ItemVariant>>;
        hasOnlyEmptyFilters(): boolean;
        get version(): number
    }
    type FilterItemStackHandler_ = FilterItemStackHandler;
    class NoiseBasedCountPlacement extends Internal.RepeatingPlacement {
        static of($$0: number, $$1: number, $$2: number): Internal.NoiseBasedCountPlacement;
        static readonly CODEC: Internal.Codec<Internal.NoiseBasedCountPlacement>;
    }
    type NoiseBasedCountPlacement_ = NoiseBasedCountPlacement;
    class AlterGroundDecorator extends Internal.TreeDecorator {
        constructor($$0: Internal.BlockStateProvider_)
        static readonly CODEC: Internal.Codec<Internal.AlterGroundDecorator>;
    }
    type AlterGroundDecorator_ = AlterGroundDecorator;
    class ValueSettingsFormatter {
        constructor(formatter: Internal.Function_<Internal.ValueSettingsBehaviour$ValueSettings, Internal.MutableComponent>)
        format(valueSettings: Internal.ValueSettingsBehaviour$ValueSettings_): Internal.MutableComponent;
    }
    type ValueSettingsFormatter_ = ValueSettingsFormatter;
    class GeneratorConfig implements Internal.IEnergyConfig<owmii.powah.block.Tier> {
        constructor(capacities: Internal.TieredEnergyValues_, transfer_rates: Internal.TieredEnergyValues_, generation_rates: Internal.TieredEnergyValues_)
        getTransfer(arg0: Internal.Enum_<any>): number;
        getTransfer(variant: owmii.powah.block.Tier_): number;
        getCapacity(arg0: Internal.Enum_<any>): number;
        getCapacity(variant: owmii.powah.block.Tier_): number;
        getGeneration(variant: owmii.powah.block.Tier_): number;
        transfer_rates: Internal.TieredEnergyValues;
        capacities: Internal.TieredEnergyValues;
        generation_rates: Internal.TieredEnergyValues;
    }
    type GeneratorConfig_ = GeneratorConfig;
    class Field extends Internal.AccessibleObject implements Internal.Member {
        getModifiers(): number;
        set(arg0: any, arg1: any): void;
        setShort(arg0: any, arg1: number): void;
        getType(): typeof any;
        getChar(arg0: any): string;
        getInt(arg0: any): number;
        getName(): string;
        getLong(arg0: any): number;
        setDouble(arg0: any, arg1: number): void;
        getAnnotatedType(): Internal.AnnotatedType;
        getGenericType(): Internal.Type;
        getShort(arg0: any): number;
        isEnumConstant(): boolean;
        getAnnotationsByType<T extends Internal.Annotation>(arg0: T): T[];
        setInt(arg0: any, arg1: number): void;
        accessFlags(): Internal.Set<Internal.AccessFlag>;
        getFloat(arg0: any): number;
        getBoolean(arg0: any): boolean;
        isSynthetic(): boolean;
        getAnnotation<T extends Internal.Annotation>(arg0: T): T;
        setByte(arg0: any, arg1: number): void;
        setBoolean(arg0: any, arg1: boolean): void;
        setFloat(arg0: any, arg1: number): void;
        getDeclaringClass(): typeof any;
        getByte(arg0: any): number;
        toGenericString(): string;
        setChar(arg0: any, arg1: string): void;
        getDouble(arg0: any): number;
        get(arg0: any): any;
        setLong(arg0: any, arg1: number): void;
        get modifiers(): number
        get type(): typeof any
        get name(): string
        get annotatedType(): Internal.AnnotatedType
        get genericType(): Internal.Type
        get enumConstant(): boolean
        get synthetic(): boolean
        get declaringClass(): typeof any
    }
    type Field_ = Field;
    class BooleanConfig extends Internal.ConfigWithVariants<boolean> {
        constructor()
        getColor(v: boolean): Internal.Color4I;
        getIcon(v: boolean): Internal.Icon;
        getIteration(currentValue: boolean, next: boolean): boolean;
        getIteration(arg0: any, arg1: boolean): any;
        getStringForGUI(v: boolean): net.minecraft.network.chat.Component;
        static readonly FALSE_TEXT: Internal.MutableComponent;
        static readonly TRUE_TEXT: Internal.MutableComponent;
    }
    type BooleanConfig_ = BooleanConfig;
    interface ReferenceCounted {
        abstract touch(arg0: any): this;
        abstract retain(): this;
        abstract release(arg0: number): boolean;
        abstract touch(): this;
        abstract refCnt(): number;
        abstract release(): boolean;
        abstract retain(arg0: number): this;
    }
    type ReferenceCounted_ = ReferenceCounted;
    class ItemRenderer implements software.bernie.geckolib.mixins.fabric.ItemRendererAccessor, Internal.ResourceManagerReloadListener, net.mehvahdjukaar.moonlight.core.mixins.fabric.ItemRendererAccessor, Internal.AccessItemRenderer, io.github.fabricators_of_create.porting_lib.mixin.accessors.client.accessor.ItemRendererAccessor, dev.emi.emi.mixin.accessor.ItemRendererAccessor, Internal.IdentifiableResourceReloadListener, Internal.ItemRendererAccessor {
        constructor($$0: Internal.Minecraft_, $$1: Internal.TextureManager_, $$2: Internal.ModelManager_, $$3: Internal.ItemColors_, $$4: Internal.BlockEntityWithoutLevelRenderer_)
        static getFoilBuffer($$0: Internal.MultiBufferSource_, $$1: Internal.RenderType_, $$2: boolean, $$3: boolean): Internal.VertexConsumer;
        renderModelLists($$0: Internal.BakedModel_, $$1: Internal.ItemStack_, $$2: number, $$3: number, $$4: Internal.PoseStack_, $$5: Internal.VertexConsumer_): void;
        invokeRenderBakedItemModel(arg0: Internal.BakedModel_, arg1: Internal.ItemStack_, arg2: number, arg3: number, arg4: Internal.PoseStack_, arg5: Internal.VertexConsumer_): void;
        getBlockEntityRenderer(): Internal.BlockEntityWithoutLevelRenderer;
        static getFoilBufferDirect($$0: Internal.MultiBufferSource_, $$1: Internal.RenderType_, $$2: boolean, $$3: boolean): Internal.VertexConsumer;
        wrapOperation$bao000$arsenal$preventTridentModel2(instance: Internal.ItemStack_, item: Internal.Item_, original: Internal.Operation_<any>): boolean;
        wrapOperation$bao000$arsenal$preventTridentModel1(instance: Internal.ItemStack_, item: Internal.Item_, original: Internal.Operation_<any>): boolean;
        renderStatic($$0: Internal.ItemStack_, $$1: Internal.ItemDisplayContext_, $$2: number, $$3: number, $$4: Internal.PoseStack_, $$5: Internal.MultiBufferSource_, $$6: Internal.Level_, $$7: number): void;
        getModel($$0: Internal.ItemStack_, $$1: Internal.Level_, $$2: Internal.LivingEntity_, $$3: number): Internal.BakedModel;
        wrapOperation$dhl000$inline$renderDetailTextureBakedModel(renderer: Internal.ItemRenderer_, model: Internal.BakedModel_, stack: Internal.ItemStack_, light: number, overlay: number, matrices: Internal.PoseStack_, vertices: Internal.VertexConsumer_, original: Internal.Operation_<any>, stackEnclosing: Internal.ItemStack_, renderMode: Internal.ItemDisplayContext_, leftHanded: boolean, matricesEnclosing: Internal.PoseStack_, vcp: Internal.MultiBufferSource_): void;
        renderQuadList($$0: Internal.PoseStack_, $$1: Internal.VertexConsumer_, $$2: Internal.List_<Internal.BakedQuad>, $$3: Internal.ItemStack_, $$4: number, $$5: number): void;
        wrapOperation$bao000$arsenal$preventTridentModel3(instance: Internal.ItemStack_, item: Internal.Item_, original: Internal.Operation_<any>): boolean;
        getName(): string;
        handler$dhe000$indium$hook_renderItem(stack: Internal.ItemStack_, transformMode: Internal.ItemDisplayContext_, invert: boolean, matrixStack: Internal.PoseStack_, vertexConsumerProvider: Internal.MultiBufferSource_, light: number, overlay: number, model: Internal.BakedModel_, ci: Internal.CallbackInfo_): void;
        callRenderModelLists(arg0: Internal.BakedModel_, arg1: Internal.ItemStack_, arg2: number, arg3: number, arg4: Internal.PoseStack_, arg5: Internal.VertexConsumer_): void;
        indium$renderBakedItemModel(model: Internal.BakedModel_, stack: Internal.ItemStack_, light: number, overlay: number, matrixStack: Internal.PoseStack_, buffer: Internal.VertexConsumer_): void;
        render($$0: Internal.ItemStack_, $$1: Internal.ItemDisplayContext_, $$2: boolean, $$3: Internal.PoseStack_, $$4: Internal.MultiBufferSource_, $$5: number, $$6: number, $$7: Internal.BakedModel_): void;
        static getCompassFoilBuffer($$0: Internal.MultiBufferSource_, $$1: Internal.RenderType_, $$2: Internal.PoseStack$Pose_): Internal.VertexConsumer;
        getFabricId(): ResourceLocation;
        reload($$0: Internal.PreparableReloadListener$PreparationBarrier_, $$1: Internal.ResourceManager_, $$2: Internal.ProfilerFiller_, $$3: Internal.ProfilerFiller_, $$4: Internal.Executor_, $$5: Internal.Executor_): Internal.CompletableFuture<void>;
        wrapOperation$dah000$geckolib$cancelGeckolibRender(defaultRenderer: Internal.BlockEntityWithoutLevelRenderer_, itemStack: Internal.ItemStack_, displayContext: Internal.ItemDisplayContext_, poseStack: Internal.PoseStack_, bufferSource: Internal.MultiBufferSource_, packedLight: number, packedOverlay: number, original: Internal.Operation_<any>): void;
        static getArmorFoilBuffer($$0: Internal.MultiBufferSource_, $$1: Internal.RenderType_, $$2: boolean, $$3: boolean): Internal.VertexConsumer;
        port_lib$renderQuadList(arg0: Internal.PoseStack_, arg1: Internal.VertexConsumer_, arg2: Internal.List_<any>, arg3: Internal.ItemStack_, arg4: number, arg5: number): void;
        onResourceManagerReload($$0: Internal.ResourceManager_): void;
        getFabricDependencies(): Internal.Collection<any>;
        renderStatic($$0: Internal.LivingEntity_, $$1: Internal.ItemStack_, $$2: Internal.ItemDisplayContext_, $$3: boolean, $$4: Internal.PoseStack_, $$5: Internal.MultiBufferSource_, $$6: Internal.Level_, $$7: number, $$8: number, $$9: number): void;
        static getCompassFoilBufferDirect($$0: Internal.MultiBufferSource_, $$1: Internal.RenderType_, $$2: Internal.PoseStack$Pose_): Internal.VertexConsumer;
        wrapOperation$dhl000$inline$renderDetailTextureBuiltInModel(renderer: Internal.BlockEntityWithoutLevelRenderer_, stack: Internal.ItemStack_, renderMode: Internal.ItemDisplayContext_, matrices: Internal.PoseStack_, vcp: Internal.MultiBufferSource_, light: number, overlay: number, original: Internal.Operation_<any>, stackEnclosing: Internal.ItemStack_, renderModeEncl: Internal.ItemDisplayContext_, leftHanded: boolean, matricesEnclosing: Internal.PoseStack_, vcpEncl: Internal.MultiBufferSource_): void;
        getItemModelShaper(): Internal.ItemModelShaper;
        get blockEntityRenderer(): Internal.BlockEntityWithoutLevelRenderer
        get name(): string
        get fabricId(): ResourceLocation
        get fabricDependencies(): Internal.Collection<any>
        get itemModelShaper(): Internal.ItemModelShaper
        static readonly COMPASS_FOIL_UI_SCALE: 0.5;
        static readonly COMPASS_FOIL_TEXTURE_SCALE: 0.0078125;
        static readonly ENCHANTED_GLINT_ENTITY: ResourceLocation;
        readonly textureManager: Internal.TextureManager;
        static readonly COMPASS_FOIL_FIRST_PERSON_SCALE: 0.75;
        static readonly ENCHANTED_GLINT_ITEM: ResourceLocation;
        static readonly ITEM_COUNT_BLIT_OFFSET: 200;
        static readonly TRIDENT_IN_HAND_MODEL: Internal.ModelResourceLocation;
        static readonly GUI_SLOT_CENTER_Y: 8;
        static readonly SPYGLASS_IN_HAND_MODEL: Internal.ModelResourceLocation;
        static readonly GUI_SLOT_CENTER_X: 8;
        readonly blockEntityRenderer: Internal.BlockEntityWithoutLevelRenderer;
    }
    type ItemRenderer_ = ItemRenderer;
    class BrambleBlock extends Internal.PipeBlock {
        constructor(builder: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        makeConnections(reader: Internal.BlockGetter_, pos: BlockPos_): Internal.BlockState;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type BrambleBlock_ = BrambleBlock;
    interface ISlotTracker$IItemHandlerInserter {
        abstract insertItem(arg0: number, arg1: Internal.ItemVariant_, arg2: number, arg3: Internal.TransactionContext_): number;
        (arg0: number, arg1: Internal.ItemVariant, arg2: number, arg3: Internal.TransactionContext): number;
    }
    type ISlotTracker$IItemHandlerInserter_ = ISlotTracker$IItemHandlerInserter;
    class BasinInventory extends Internal.SmartInventory {
        constructor(slots: number, be: Internal.BasinBlockEntity_)
        stopOpen($$0: Internal.Player_): void;
        count(ingredient: Internal.Ingredient_): number;
        static tryClear($$0: any): void;
        count(): number;
        supportsInsertion(): boolean;
        setTransferCooldown(currentTime: number): void;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        isEmpty(): boolean;
        clear(ingredient: Internal.Ingredient_): void;
        startOpen($$0: Internal.Player_): void;
        find(): number;
        supportsExtraction(): boolean;
        getSlots(): number;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        extractSlot(slot: number, resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        setChanged(): void;
        insertSlot(slot: number, resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        forEach(arg0: Internal.Consumer_<Internal.StorageView<T>>): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateExtract(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        canReceiveTransferCooldown(): boolean;
        spliterator(): Internal.Spliterator<Internal.StorageView<T>>;
        getStackInSlot(slot: number): Internal.ItemStack;
        getHeight(): number;
        iterator(): Internal.Iterator<Internal.StorageView<Internal.ItemVariant>>;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        countNonEmpty(): number;
        asContainer(): net.minecraft.world.Container;
        kjs$self(): net.minecraft.world.Container;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getAllItems(): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        isItemValid(slot: number, resource: Internal.ItemVariant_): boolean;
        static asClass<T>(): Internal.Storage<T>;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        serializeNBT(): Internal.CompoundTag;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        deserializeNBT(nbt: Internal.CompoundTag_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateInsert(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        isMutable(): boolean;
        clear(): void;
        find(ingredient: Internal.Ingredient_): number;
        getVersion(): number;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get slots(): number
        get height(): number
        get width(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
        get version(): number
        packagerMode: boolean;
    }
    type BasinInventory_ = BasinInventory;
    interface Palette$Factory {
        abstract create<A>(arg0: number, arg1: Internal.IdMap_<A>, arg2: Internal.PaletteResize_<A>, arg3: Internal.List_<A>): Internal.Palette<A>;
        (arg0: number, arg1: Internal.IdMap<A>, arg2: Internal.PaletteResize<A>, arg3: Internal.List<A>): Internal.Palette_<A>;
    }
    type Palette$Factory_ = Palette$Factory;
    abstract class SignBlock extends Internal.BaseEntityBlock implements Internal.SimpleWaterloggedBlock {
        getSignHitboxCenterPosition($$0: Internal.BlockState_): Vec3d;
        static getWoodType($$0: Internal.Block_): Internal.WoodType;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        openTextEdit($$0: Internal.Player_, $$1: Internal.SignBlockEntity_, $$2: boolean): void;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        type(): Internal.WoodType;
        abstract getYRotationDegrees(arg0: Internal.BlockState_): number;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly WATERLOGGED: Internal.BooleanProperty;
    }
    type SignBlock_ = SignBlock;
    interface AWTEventListener extends Internal.EventListener {
        abstract eventDispatched(arg0: Internal.AWTEvent_): void;
        (arg0: Internal.AWTEvent): void;
    }
    type AWTEventListener_ = AWTEventListener;
    class SpeakerBlock extends Internal.HorizontalDirectionalBlock implements Internal.EntityBlock {
        constructor(settings: Internal.BlockBehaviour$Properties_)
        newBlockEntity(pos: BlockPos_, state: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<U extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, type: Internal.BlockEntityType_<U>): Internal.BlockEntityTicker<U>;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type SpeakerBlock_ = SpeakerBlock;
    class HangingEntityItem extends Internal.Item {
        constructor($$0: Internal.EntityType_<Internal.HangingEntity>, $$1: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type HangingEntityItem_ = HangingEntityItem;
    class DoubleArgumentInfo implements Internal.ArgumentTypeInfo<Internal.DoubleArgumentType, Internal.DoubleArgumentInfo$Template> {
        constructor()
        unpack($$0: Internal.DoubleArgumentType_): Internal.DoubleArgumentInfo$Template;
        deserializeFromNetwork(arg0: Internal.FriendlyByteBuf_): Internal.ArgumentTypeInfo$Template<any>;
        unpack(arg0: Internal.ArgumentType_<any>): Internal.ArgumentTypeInfo$Template<any>;
        serializeToJson($$0: Internal.DoubleArgumentInfo$Template_, $$1: Internal.JsonObject_): void;
        serializeToNetwork($$0: Internal.DoubleArgumentInfo$Template_, $$1: Internal.FriendlyByteBuf_): void;
        deserializeFromNetwork($$0: Internal.FriendlyByteBuf_): Internal.DoubleArgumentInfo$Template;
        serializeToNetwork(arg0: Internal.ArgumentTypeInfo$Template_<any>, arg1: Internal.FriendlyByteBuf_): void;
        serializeToJson(arg0: Internal.ArgumentTypeInfo$Template_<any>, arg1: Internal.JsonObject_): void;
    }
    type DoubleArgumentInfo_ = DoubleArgumentInfo;
    interface IResourceIcon {
        abstract getResourceLocation(): ResourceLocation;
        get resourceLocation(): ResourceLocation
        (): ResourceLocation_;
    }
    type IResourceIcon_ = IResourceIcon;
    interface IMaterialValue {
        getMaterialValue(inv: Internal.ISingleStackContainer_): number;
        getItemsUsed(itemCost: number): number;
        getRemainder(itemCost: number): number;
        getLeftover(): Internal.ItemStack;
        abstract getMaterial(): Internal.MaterialVariant;
        abstract getValue(): number;
        getNeeded(): number;
        get leftover(): Internal.ItemStack
        get material(): Internal.MaterialVariant
        get value(): number
        get needed(): number
    }
    type IMaterialValue_ = IMaterialValue;
    class PressurePlateBlock extends Internal.BasePressurePlateBlock {
        constructor($$0: any_, $$1: Internal.BlockBehaviour$Properties_, $$2: Internal.BlockSetType_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly POWERED: Internal.BooleanProperty;
    }
    type PressurePlateBlock_ = PressurePlateBlock;
    class PaintSplotchesBlock extends Internal.AEBaseEntityBlock<any> {
        constructor()
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly LIGHT_LEVEL: Internal.IntegerProperty;
    }
    type PaintSplotchesBlock_ = PaintSplotchesBlock;
    interface Runnable {
        abstract run(): void;
        (): void;
    }
    type Runnable_ = Runnable;
    class IntArrayTag extends Internal.CollectionTag<Internal.IntTag> {
        constructor($$0: Internal.List_<number>)
        constructor($$0: number[])
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.List<E>;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.List<E>;
        add($$0: number, $$1: Internal.IntTag_): void;
        getLast(): Internal.IntTag;
        set(arg0: number, arg1: Internal.Tag_): Internal.Tag;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.List<E>;
        removeLast(): Internal.IntTag;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.List<E>;
        addFirst(arg0: Internal.IntTag_): void;
        forEach(arg0: Internal.Consumer_<Internal.IntTag>): void;
        spliterator(): Internal.Spliterator<Internal.IntTag>;
        removeIf(arg0: Internal.Predicate_<Internal.IntTag>): boolean;
        getAsIntArray(): number[];
        replaceAll(arg0: Internal.UnaryOperator_<Internal.IntTag>): void;
        static of<E>(arg0: E): Internal.List<E>;
        static of<E>(): Internal.List<E>;
        static of<E>(...arg0: E[]): Internal.List<E>;
        getFirst(): Internal.IntTag;
        acceptAsRoot($$0: Internal.StreamTagVisitor_): void;
        removeFirst(): Internal.IntTag;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        sort(arg0: Internal.Comparator_<Internal.IntTag>): void;
        reversed(): Internal.SequencedCollection<any>;
        set($$0: number, $$1: Internal.IntTag_): Internal.IntTag;
        stream(): Internal.Stream<Internal.IntTag>;
        get($$0: number): Internal.IntTag;
        getType(): Internal.TagType<Internal.IntArrayTag>;
        addLast(arg0: Internal.IntTag_): void;
        remove($$0: number): Internal.IntTag;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.List<E>;
        abstract toArray<T>(arg0: T[]): T[];
        remove(arg0: number): Internal.Tag;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.List<E>;
        get(arg0: number): any;
        getAsString(): string;
        static of<E>(arg0: E, arg1: E): Internal.List<E>;
        parallelStream(): Internal.Stream<Internal.IntTag>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.List<E>;
        copy(): this;
        get last(): Internal.IntTag
        get asIntArray(): number[]
        get first(): Internal.IntTag
        get type(): Internal.TagType<Internal.IntArrayTag>
        get asString(): string
        static readonly TYPE: Internal.TagType<Internal.IntArrayTag>;
    }
    type IntArrayTag_ = IntArrayTag;
    class MagmaBlock extends Internal.Block {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type MagmaBlock_ = MagmaBlock;
    class Stacks extends Internal.NonNullList<Internal.ItemStack> {
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.List<E>;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.List<E>;
        removeLast(): Internal.ItemStack;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.List<E>;
        stream(): Internal.Stream<Internal.ItemStack>;
        static from(stacks: Internal.NonNullList_<Internal.ItemStack>): Internal.Stacks;
        static of<E>(arg0: E): Internal.List<E>;
        static of<E>(): Internal.List<E>;
        static of<E>(...arg0: E[]): Internal.List<E>;
        static withSize(size: number, fill: Internal.ItemStack_): Internal.Stacks;
        getLast(): Internal.ItemStack;
        static create(): Internal.Stacks;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        replaceAll(arg0: Internal.UnaryOperator_<Internal.ItemStack>): void;
        reversed(): Internal.SequencedCollection<any>;
        addFirst(arg0: Internal.ItemStack_): void;
        copy(): this;
        addLast(arg0: Internal.ItemStack_): void;
        parallelStream(): Internal.Stream<Internal.ItemStack>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.List<E>;
        abstract toArray<T>(arg0: T[]): T[];
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.List<E>;
        removeFirst(): Internal.ItemStack;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.List<E>;
        sort(arg0: Internal.Comparator_<Internal.ItemStack>): void;
        static from(...elements: Internal.ItemStack_[]): Internal.Stacks;
        spliterator(): Internal.Spliterator<Internal.ItemStack>;
        static of<E>(arg0: E, arg1: E): Internal.List<E>;
        forEach(arg0: Internal.Consumer_<Internal.ItemStack>): void;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.List<E>;
        getFirst(): Internal.ItemStack;
        removeIf(arg0: Internal.Predicate_<Internal.ItemStack>): boolean;
        get last(): Internal.ItemStack
        get first(): Internal.ItemStack
    }
    type Stacks_ = Stacks;
    class SpikeFeature$EndSpike {
        constructor($$0: number, $$1: number, $$2: number, $$3: number, $$4: boolean)
        isCenterWithinChunk($$0: BlockPos_): boolean;
        getRadius(): number;
        getCenterX(): number;
        getTopBoundingBox(): Internal.AABB;
        getCenterZ(): number;
        getHeight(): number;
        isGuarded(): boolean;
        get radius(): number
        get centerX(): number
        get topBoundingBox(): Internal.AABB
        get centerZ(): number
        get height(): number
        get guarded(): boolean
        static readonly CODEC: Internal.Codec<Internal.SpikeFeature$EndSpike>;
    }
    type SpikeFeature$EndSpike_ = SpikeFeature$EndSpike;
    class BlueprintItem extends Internal.Item {
        constructor(p_i48487_1_: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        static assignCompleteRecipe(level: Internal.Level_, inv: io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler_, recipe: Internal.Recipe_<any>): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type BlueprintItem_ = BlueprintItem;
    class AgriFertilizerParticle extends Internal.Record {
        constructor(particle: string, deltaX: number, deltaY: number, deltaZ: number, amount: number, when: Internal.List_<string>)
        deltaX(): number;
        deltaY(): number;
        particle(): string;
        when(): Internal.List<string>;
        amount(): number;
        deltaZ(): number;
        static readonly CODEC: Internal.Codec<Internal.AgriFertilizerParticle>;
    }
    type AgriFertilizerParticle_ = AgriFertilizerParticle;
    interface AttributeSet$ColorAttribute {
    }
    type AttributeSet$ColorAttribute_ = AttributeSet$ColorAttribute;
    class RenderRegionCache {
        constructor()
        createRegion($$0: Internal.Level_, $$1: BlockPos_, $$2: BlockPos_, $$3: number): Internal.RenderChunkRegion;
    }
    type RenderRegionCache_ = RenderRegionCache;
    interface IMemoryCard {
        abstract setMemoryCardContents(arg0: Internal.ItemStack_, arg1: string, arg2: Internal.CompoundTag_): void;
        abstract getColorCode(arg0: Internal.ItemStack_): Internal.AEColor[];
        abstract getSettingsName(arg0: Internal.ItemStack_): string;
        abstract notifyUser(arg0: Internal.Player_, arg1: Internal.MemoryCardMessages_): void;
        abstract getData(arg0: Internal.ItemStack_): Internal.CompoundTag;
        readonly NBT_COLOR_CODE: "colorCode";
    }
    type IMemoryCard_ = IMemoryCard;
    class LightningDragonCaveStructure extends Internal.DragonCaveStructure {
        static readonly CODEC: Internal.Codec<Internal.LightningDragonCaveStructure>;
    }
    type LightningDragonCaveStructure_ = LightningDragonCaveStructure;
    interface SystemReportAccessor {
        abstract getEntries(): Internal.Map<string, string>;
        getOPERATING_SYSTEM(): string;
        getJAVA_VERSION(): string;
        get entries(): Internal.Map<string, string>
        get OPERATING_SYSTEM(): string
        get JAVA_VERSION(): string
        (): Internal.Map_<string, string>;
    }
    type SystemReportAccessor_ = SystemReportAccessor;
    class OrientedContraptionEntity extends Internal.AbstractContraptionEntity implements Internal.AccessorOrientedContraptionEntity {
        constructor(type: Internal.EntityType_<any>, world: Internal.Level_)
        setMotionY(y: number): void;
        setCouplingId(id: Internal.UUID_): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        getType(): string;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        self(): Internal.Entity;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        startAtInitialYaw(): void;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        static handleRelocationPacket(packet: Internal.ContraptionRelocationPacket_): void;
        alwaysAccepts(): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        static createAtYaw(world: Internal.Level_, contraption: Internal.Contraption_, initialOrientation: Internal.Direction_, initialYaw: number): Internal.OrientedContraptionEntity;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        getDisplayName(): net.minecraft.network.chat.Component;
        setInitialOrientation(direction: Internal.Direction_): void;
        setMotionX(x: number): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        getCoupledCartsIfPresent(): Internal.Couple<Internal.MinecartController>;
        getInitialYaw(): number;
        attack(hp: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getCouplingId(): Internal.UUID;
        serializeNBT(): Internal.Tag;
        startAtYaw(yaw: number): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        railways$makeStructureTransform(): Internal.StructureTransform;
        getMotionX(): number;
        static create(world: Internal.Level_, contraption: Internal.Contraption_, initialOrientation: Internal.Direction_): Internal.OrientedContraptionEntity;
        isWaterCreature(): boolean;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        getInitialOrientation(): Internal.Direction;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        lithiumOnBlockCacheDeleted(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        runCommand(command: string): number;
        isInitialOrientationPresent(): boolean;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        set couplingId(id: Internal.UUID_)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        set initialOrientation(direction: Internal.Direction_)
        set motionX(x: number)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get coupledCartsIfPresent(): Internal.Couple<Internal.MinecartController>
        get initialYaw(): number
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        get couplingId(): Internal.UUID
        set dynamicLightEnabled(enabled: boolean)
        get motionX(): number
        get waterCreature(): boolean
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        get initialOrientation(): Internal.Direction
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        get profile(): Internal.GameProfile
        get initialOrientationPresent(): boolean
        pitch: number;
        nonDamageTicks: number;
        yaw: number;
        prevYaw: number;
        targetYaw: number;
        prevPitch: number;
    }
    type OrientedContraptionEntity_ = OrientedContraptionEntity;
    class EasingType$CatmullRomEasing implements Internal.EasingType {
        constructor()
        static elastic(n: number): Internal.Double2DoubleFunction;
        static sine(n: number): number;
        static exp(n: number): number;
        static linear(n: number): number;
        static quadratic(n: number): number;
        static easeOut(function_: Internal.Double2DoubleFunction_): Internal.Double2DoubleFunction;
        static register(name: string, easingType: Internal.EasingType_): Internal.EasingType;
        static step(n: number): Internal.Double2DoubleFunction;
        static circle(n: number): number;
        static catmullRom(n: number): number;
        static pow(n: number): Internal.Double2DoubleFunction;
        static stepPositive(function_: Internal.Double2DoubleFunction_): Internal.Double2DoubleFunction;
        static fromString(name: string): Internal.EasingType;
        static fromJson(json: Internal.JsonElement_): Internal.EasingType;
        static cubic(n: number): number;
        static easeIn(function_: Internal.Double2DoubleFunction_): Internal.Double2DoubleFunction;
        static linear(function_: Internal.Double2DoubleFunction_): Internal.Double2DoubleFunction;
        apply(animationPoint: Internal.AnimationPoint_): number;
        static back(n: number): Internal.Double2DoubleFunction;
        static lerpWithOverride(animationPoint: Internal.AnimationPoint_, override: Internal.EasingType_): number;
        static easeInOut(function_: Internal.Double2DoubleFunction_): Internal.Double2DoubleFunction;
        buildTransformer(value: number): Internal.Double2DoubleFunction;
        static getPointOnSpline(delta: number, p0: number, p1: number, p2: number, p3: number): number;
        static stepNonNegative(function_: Internal.Double2DoubleFunction_): Internal.Double2DoubleFunction;
        static bounce(n: number): Internal.Double2DoubleFunction;
        apply(animationPoint: Internal.AnimationPoint_, easingValue: number, lerpValue: number): number;
    }
    type EasingType$CatmullRomEasing_ = EasingType$CatmullRomEasing;
    abstract class ImmutableSet <E> extends Internal.ImmutableCollection<E> implements Internal.Set<E> {
        static of<E>(): Internal.ImmutableSet<E>;
        static of<E>(arg0: E): Internal.ImmutableSet<E>;
        static builderWithExpectedSize<E>(arg0: number): Internal.ImmutableSet$Builder<E>;
        parallelStream(): Internal.Stream<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.Set<E>;
        static copyOf<E>(arg0: Internal.Iterable_<E>): Internal.ImmutableSet<E>;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.ImmutableSet<E>;
        static copyOf<E>(arg0: E[]): Internal.ImmutableSet<E>;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        static toImmutableSet<E>(): Internal.Collector<E, any, Internal.ImmutableSet<E>>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E): Internal.ImmutableSet<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.Set<E>;
        iterator(): Internal.Iterator<any>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.ImmutableSet<E>;
        forEach(arg0: Internal.Consumer_<E>): void;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.ImmutableSet<E>;
        abstract toArray<T>(arg0: T[]): T[];
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.ImmutableSet<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, ...arg6: E[]): Internal.ImmutableSet<E>;
        static builder<E>(): Internal.ImmutableSet$Builder<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.Set<E>;
        static of<E>(...arg0: E[]): Internal.Set<E>;
        stream(): Internal.Stream<E>;
        spliterator(): Internal.Spliterator<E>;
        static copyOf<E>(arg0: Internal.Iterator_<E>): Internal.ImmutableSet<E>;
    }
    type ImmutableSet_<E> = ImmutableSet<E>;
    class GarbageIota$1 extends Internal.IotaType<Internal.GarbageIota> {
        deserialize(tag: Internal.Tag_, world: Internal.ServerLevel_): Internal.GarbageIota;
    }
    type GarbageIota$1_ = GarbageIota$1;
    interface ShovelItemAccessor {
        getPathStates(): Internal.Map<Internal.Block, Internal.BlockState>;
        get pathStates(): Internal.Map<Internal.Block, Internal.BlockState>
    }
    type ShovelItemAccessor_ = ShovelItemAccessor;
    class ChargingConfig implements Internal.IEnergyConfig<owmii.powah.block.Tier> {
        constructor(capacities: Internal.TieredEnergyValues_, transfer_rates: Internal.TieredEnergyValues_, charging_rates: Internal.TieredEnergyValues_)
        getTransfer(arg0: Internal.Enum_<any>): number;
        getTransfer(variant: owmii.powah.block.Tier_): number;
        getChargingSpeed(variant: owmii.powah.block.Tier_): number;
        getCapacity(arg0: Internal.Enum_<any>): number;
        getCapacity(variant: owmii.powah.block.Tier_): number;
        transfer_rates: Internal.TieredEnergyValues;
        capacities: Internal.TieredEnergyValues;
        charging_rates: Internal.TieredEnergyValues;
    }
    type ChargingConfig_ = ChargingConfig;
    class DelegatedStencilElement extends Internal.AbstractRenderElement implements Internal.StencilElement {
        constructor()
        constructor(stencil: Internal.FadableScreenElement_, element: Internal.FadableScreenElement_)
        withStencilRenderer<T extends Internal.DelegatedStencilElement>(renderer: Internal.FadableScreenElement_): T;
        withElementRenderer<T extends Internal.DelegatedStencilElement>(renderer: Internal.FadableScreenElement_): T;
        render(graphics: Internal.GuiGraphics_, x: number, y: number): void;
        renderStencil(graphics: Internal.GuiGraphics_): void;
        renderElement(graphics: Internal.GuiGraphics_): void;
        render(graphics: Internal.GuiGraphics_, x: number, y: number, alpha: number): void;
        render(graphics: Internal.GuiGraphics_): void;
        prepareStencil(graphics: Internal.GuiGraphics_): void;
        transform(graphics: Internal.GuiGraphics_): void;
        prepareElement(graphics: Internal.GuiGraphics_): void;
        cleanUp(graphics: Internal.GuiGraphics_): void;
        static of(renderable: Internal.ScreenElement_): Internal.RenderElement;
    }
    type DelegatedStencilElement_ = DelegatedStencilElement;
    class Configuration {
        resolveAndBind(arg0: Internal.ModuleFinder_, arg1: Internal.ModuleFinder_, arg2: Internal.Collection_<string>): this;
        static resolve(arg0: Internal.ModuleFinder_, arg1: Internal.List_<Internal.Configuration>, arg2: Internal.ModuleFinder_, arg3: Internal.Collection_<string>): Internal.Configuration;
        parents(): Internal.List<Internal.Configuration>;
        modules(): Internal.Set<Internal.ResolvedModule>;
        resolve(arg0: Internal.ModuleFinder_, arg1: Internal.ModuleFinder_, arg2: Internal.Collection_<string>): this;
        static resolveAndBind(arg0: Internal.ModuleFinder_, arg1: Internal.List_<Internal.Configuration>, arg2: Internal.ModuleFinder_, arg3: Internal.Collection_<string>): Internal.Configuration;
        static empty(): Internal.Configuration;
        findModule(arg0: string): Internal.Optional<Internal.ResolvedModule>;
    }
    type Configuration_ = Configuration;
    interface OutputReplacementTransformer {
        abstract transform(arg0: Internal.RecipeKJS_, arg1: Internal.ReplacementMatch_, arg2: Internal.OutputReplacement_, arg3: Internal.OutputReplacement_): any;
        (arg0: Internal.RecipeKJS, arg1: Internal.ReplacementMatch, arg2: Internal.OutputReplacement, arg3: Internal.OutputReplacement): any;
    }
    type OutputReplacementTransformer_ = OutputReplacementTransformer;
    interface EntityExtensions {
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        canRiderInteract(): boolean;
        getCustomData(): Internal.CompoundTag;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        get customData(): Internal.CompoundTag
    }
    type EntityExtensions_ = EntityExtensions;
    interface AccessorPartialModel {
        railways$setPopulateOnInit(tooLate: boolean): void;
        abstract railways$setBakedModel(arg0: Internal.BakedModel_): void;
        railways$getPopulateOnInit(): boolean;
        railways$getALL(): Internal.ConcurrentMap<ResourceLocation, Internal.PartialModel>;
        (arg0: Internal.BakedModel): void;
    }
    type AccessorPartialModel_ = AccessorPartialModel;
    class VariableSet implements Internal.UnitVariables {
        constructor()
        setMutable(name: string, initialValue: number): Internal.MutableNumberUnit;
        createSubset(): this;
        get(entry: string): Internal.Unit;
        set(name: string, value: Internal.Unit_): this;
        getVariables(): this;
        set(name: string, value: number): this;
        get variables(): Internal.VariableSet
    }
    type VariableSet_ = VariableSet;
    class LoreItem extends Internal.Item {
        constructor(properties: Internal.Item$Properties_, ...lore: net.minecraft.network.chat.Component_[])
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type LoreItem_ = LoreItem;
    class PlacementContext extends Internal.WorldGenerationContext {
        constructor($$0: Internal.WorldGenLevel_, $$1: Internal.ChunkGenerator_, $$2: Internal.Optional_<Internal.PlacedFeature>)
        generator(): Internal.ChunkGenerator;
        getHeight($$0: Internal.Heightmap$Types_, $$1: number, $$2: number): number;
        getMinBuildHeight(): number;
        topFeature(): Internal.Optional<Internal.PlacedFeature>;
        getBlockState($$0: BlockPos_): Internal.BlockState;
        getLevel(): Internal.WorldGenLevel;
        getCarvingMask($$0: Internal.ChunkPos_, $$1: Internal.GenerationStep$Carving_): Internal.CarvingMask;
        get minBuildHeight(): number
        get level(): Internal.WorldGenLevel
    }
    type PlacementContext_ = PlacementContext;
    class MaterialRecipe implements Internal.IMaterialValue, Internal.ICustomOutputRecipe<Internal.ISingleStackContainer> {
        constructor(id: ResourceLocation_, group: string, ingredient: Internal.Ingredient_, value: number, needed: number, materialId: Internal.MaterialVariantId_, leftover: any_)
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        /**
         * @deprecated
        */
        assemble(inv: Internal.ISingleStackContainer_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        getMaterial(): Internal.MaterialVariant;
        getNeeded(): number;
        getSerializer(): Internal.RecipeSerializer<any>;
        getId(): ResourceLocation;
        getValue(): number;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        getIngredient(): Internal.Ingredient;
        getMod(): string;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        getMaterialValue(inv: Internal.ISingleStackContainer_): number;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getLeftover(): Internal.ItemStack;
        /**
         * @deprecated
        */
        getResultItem(access: Internal.RegistryAccess_): Internal.ItemStack;
        /**
         * @deprecated
        */
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        getDisplayItems(): Internal.List<Internal.ItemStack>;
        setGroup(group: string): void;
        getItemsUsed(itemCost: number): number;
        getOrCreateId(): ResourceLocation;
        getRemainder(itemCost: number): number;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        static getRepairDurability(toolData: Internal.ToolDefinitionData_, materialId: Internal.MaterialId_, statsId: Internal.MaterialStatsId_): number;
        getRepairPerItem(data: Internal.ToolDefinitionData_, statsId: Internal.MaterialStatsId_): number;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getRemainingItems($$0: Internal.ISingleStackContainer_): Internal.NonNullList<Internal.ItemStack>;
        matches(inv: Internal.ISingleStackContainer_, worldIn: Internal.Level_): boolean;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get material(): Internal.MaterialVariant
        get needed(): number
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get value(): number
        get ingredient(): Internal.Ingredient
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get leftover(): Internal.ItemStack
        get type(): ResourceLocation
        get displayItems(): Internal.List<Internal.ItemStack>
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        static readonly INGOTS_PER_REPAIR: 3.0;
    }
    type MaterialRecipe_ = MaterialRecipe;
    interface ICastingContainer extends Internal.ISingleStackContainer {
        stopOpen($$0: Internal.Player_): void;
        count(ingredient: Internal.Ingredient_): number;
        tryClear($$0: any): void;
        count(): number;
        setTransferCooldown(currentTime: number): void;
        countItem(itemIn: Internal.Item_): number;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        isEmpty(): boolean;
        clear(ingredient: Internal.Ingredient_): void;
        startOpen($$0: Internal.Player_): void;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        find(): number;
        hasAnyOf(set: Internal.Set_<Internal.Item>): boolean;
        /**
         * @deprecated
        */
        removeItem(index: number, count: number): Internal.ItemStack;
        abstract getStack(): Internal.ItemStack;
        getSlots(): number;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        /**
         * @deprecated
        */
        setChanged(): void;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        /**
         * @deprecated
        */
        getContainerSize(): number;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        /**
         * @deprecated
        */
        setItem(index: number, stack: Internal.ItemStack_): void;
        getHeight(): number;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        countNonEmpty(): number;
        asContainer(): net.minecraft.world.Container;
        kjs$self(): net.minecraft.world.Container;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        getAllItems(): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        removeItemNoUpdate(index: number): Internal.ItemStack;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        /**
         * @deprecated
        */
        stillValid(player: Internal.Player_): boolean;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        isMutable(): boolean;
        clear(): void;
        /**
         * @deprecated
        */
        getItem(index: number): Internal.ItemStack;
        find(ingredient: Internal.Ingredient_): number;
        abstract getFluid(): Internal.Fluid;
        getFluidTag(): Internal.CompoundTag;
        /**
         * @deprecated
        */
        clearContent(): void;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get stack(): Internal.ItemStack
        get slots(): number
        /**
         * @deprecated
        */
        get containerSize(): number
        get height(): number
        get width(): number
        get maxStackSize(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
        get fluid(): Internal.Fluid
        get fluidTag(): Internal.CompoundTag
    }
    type ICastingContainer_ = ICastingContainer;
    class StructureSpawnOverride$BoundingBoxType extends Internal.Enum<Internal.StructureSpawnOverride$BoundingBoxType> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static values(): Internal.StructureSpawnOverride$BoundingBoxType[];
        getSerializedName(): string;
        static valueOf($$0: string): Internal.StructureSpawnOverride$BoundingBoxType;
        get serializedName(): string
        static readonly STRUCTURE: Internal.StructureSpawnOverride$BoundingBoxType;
        static readonly CODEC: Internal.Codec<Internal.StructureSpawnOverride$BoundingBoxType>;
        static readonly PIECE: Internal.StructureSpawnOverride$BoundingBoxType;
    }
    type StructureSpawnOverride$BoundingBoxType_ = StructureSpawnOverride$BoundingBoxType | "structure" | "piece";
    class HighGrassFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(p_67292_: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        static placeWeepingVinesColumn(p_225301_: Internal.LevelAccessor_, p_225302_: Internal.RandomSource_, p_225303_: Internal.BlockPos$MutableBlockPos_, p_225304_: number, p_225305_: number, p_225306_: number): void;
    }
    type HighGrassFeature_ = HighGrassFeature;
    class WispjellyBlock extends Internal.Block {
        constructor(p_153282_: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type WispjellyBlock_ = WispjellyBlock;
    class EntityNameDisplaySource extends Internal.SingleLineDisplaySource {
        constructor()
    }
    type EntityNameDisplaySource_ = EntityNameDisplaySource;
    class LargeFumaroleFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        checkSpace(world: Internal.WorldGenLevel_, pos: BlockPos_): boolean;
        setBlock(world: Internal.WorldGenLevel_, pos: BlockPos_, state: Internal.BlockState_): boolean;
    }
    type LargeFumaroleFeature_ = LargeFumaroleFeature;
    interface IAEPowerStorage extends Internal.IEnergySource, Internal.IGridNodeService {
        abstract getAEMaxPower(): number;
        abstract getPowerFlow(): Internal.AccessRestriction;
        getPriority(): number;
        abstract injectAEPower(arg0: number, arg1: Internal.Actionable_): number;
        abstract isAEPublicPowerStorage(): boolean;
        abstract getAECurrentPower(): number;
        abstract extractAEPower(arg0: number, arg1: Internal.Actionable_, arg2: Internal.PowerMultiplier_): number;
        get AEMaxPower(): number
        get powerFlow(): Internal.AccessRestriction
        get priority(): number
        get AEPublicPowerStorage(): boolean
        get AECurrentPower(): number
    }
    type IAEPowerStorage_ = IAEPowerStorage;
    class SimpleTexture extends Internal.AbstractTexture implements Internal.SimpleTextureAccessor {
        constructor($$0: ResourceLocation_)
        getLocation(): ResourceLocation;
        get location(): ResourceLocation
    }
    type SimpleTexture_ = SimpleTexture;
    class HashSet <E> extends Internal.AbstractSet<E> implements Internal.Cloneable, Internal.Set<E>, Internal.Serializable {
        constructor()
        constructor(arg0: Internal.Collection_<E>)
        constructor(arg0: number)
        constructor(arg0: number, arg1: number)
        clone(): any;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.Set<E>;
        forEach(arg0: Internal.Consumer_<E>): void;
        toArray<T>(arg0: T[]): T[];
        static newHashSet<T>(arg0: number): Internal.HashSet<T>;
        parallelStream(): Internal.Stream<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.Set<E>;
        iterator(): Internal.Iterator<E>;
        static of<E>(arg0: E): Internal.Set<E>;
        static of<E>(): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.Set<E>;
        static of<E>(...arg0: E[]): Internal.Set<E>;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        stream(): Internal.Stream<E>;
        static of<E>(arg0: E, arg1: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.Set<E>;
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.Set<E>;
        spliterator(): Internal.Spliterator<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.Set<E>;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.Set<E>;
    }
    type HashSet_<E> = HashSet<E>;
    interface IGridService {
    }
    type IGridService_ = IGridService;
    class StringArgumentType implements Internal.ArgumentType<string> {
        getType(): Internal.StringArgumentType$StringType;
        static string(): Internal.StringArgumentType;
        getExamples(): Internal.Collection<string>;
        static word(): Internal.StringArgumentType;
        static escapeIfRequired(arg0: string): string;
        static greedyString(): Internal.StringArgumentType;
        listSuggestions<S>(arg0: Internal.CommandContext_<S>, arg1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        static getString(arg0: Internal.CommandContext_<any>, arg1: string): string;
        parse(arg0: Internal.StringReader_): any;
        get type(): Internal.StringArgumentType$StringType
        get examples(): Internal.Collection<string>
    }
    type StringArgumentType_ = StringArgumentType;
    interface Arena extends Internal.SegmentAllocator, Internal.AutoCloseable {
        allocateArray(arg0: Internal.ValueLayout$OfShort_, ...arg1: number[]): Internal.MemorySegment;
        allocate(arg0: Internal.ValueLayout$OfLong_, arg1: number): Internal.MemorySegment;
        allocate(arg0: number, arg1: number): Internal.MemorySegment;
        allocate(arg0: Internal.AddressLayout_, arg1: Internal.MemorySegment_): Internal.MemorySegment;
        allocateArray(arg0: Internal.ValueLayout$OfDouble_, ...arg1: number[]): Internal.MemorySegment;
        allocateUtf8String(arg0: string): Internal.MemorySegment;
        slicingAllocator(arg0: Internal.MemorySegment_): Internal.SegmentAllocator;
        allocate(arg0: Internal.ValueLayout$OfFloat_, arg1: number): Internal.MemorySegment;
        global(): this;
        prefixAllocator(arg0: Internal.MemorySegment_): Internal.SegmentAllocator;
        allocate(arg0: Internal.ValueLayout$OfDouble_, arg1: number): Internal.MemorySegment;
        allocateArray(arg0: Internal.ValueLayout$OfChar_, ...arg1: string[]): Internal.MemorySegment;
        allocate(arg0: Internal.ValueLayout$OfInt_, arg1: number): Internal.MemorySegment;
        allocateArray(arg0: Internal.ValueLayout$OfFloat_, ...arg1: number[]): Internal.MemorySegment;
        ofAuto(): this;
        allocateArray(arg0: Internal.ValueLayout$OfByte_, ...arg1: number[]): Internal.MemorySegment;
        ofConfined(): this;
        abstract scope(): Internal.MemorySegment$Scope;
        allocate(arg0: Internal.MemoryLayout_): Internal.MemorySegment;
        allocate(arg0: Internal.ValueLayout$OfChar_, arg1: string): Internal.MemorySegment;
        allocate(arg0: Internal.ValueLayout$OfShort_, arg1: number): Internal.MemorySegment;
        allocateArray(arg0: Internal.ValueLayout$OfInt_, ...arg1: number[]): Internal.MemorySegment;
        abstract close(): void;
        allocate(arg0: Internal.ValueLayout$OfByte_, arg1: number): Internal.MemorySegment;
        allocateArray(arg0: Internal.MemoryLayout_, arg1: number): Internal.MemorySegment;
        allocateArray(arg0: Internal.ValueLayout$OfLong_, ...arg1: number[]): Internal.MemorySegment;
        allocate(arg0: number): Internal.MemorySegment;
        ofShared(): this;
    }
    type Arena_ = Arena;
    interface BlendingStateHolder {
        abstract getTransparencyType(): Internal.TransparencyType;
        abstract setTransparencyType(arg0: Internal.TransparencyType_): void;
        get transparencyType(): Internal.TransparencyType
        set transparencyType(arg0: Internal.TransparencyType_)
    }
    type BlendingStateHolder_ = BlendingStateHolder;
    class HarvesterBlock extends Internal.AttachedActorBlock implements Internal.IBE<Internal.HarvesterBlockEntity> {
        constructor(p_i48377_1_: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.HarvesterBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.HarvesterBlockEntity>): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getBlockEntityClass(): typeof Internal.HarvesterBlockEntity;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.HarvesterBlockEntity>;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.HarvesterBlockEntity;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        getBlockEntityType(): Internal.BlockEntityType<Internal.HarvesterBlockEntity>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        get blockEntityClass(): typeof Internal.HarvesterBlockEntity
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<Internal.HarvesterBlockEntity>
    }
    type HarvesterBlock_ = HarvesterBlock;
    abstract class WaterAnimal extends Internal.PathfinderMob {
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        static checkSurfaceWaterAnimalSpawnRules($$0: Internal.EntityType_<Internal.WaterAnimal>, $$1: Internal.LevelAccessor_, $$2: Internal.MobSpawnType_, $$3: BlockPos_, $$4: Internal.RandomSource_): boolean;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type WaterAnimal_ = WaterAnimal;
    class ExtraGlowLichenFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type ExtraGlowLichenFeature_ = ExtraGlowLichenFeature;
    class CountPlacement extends Internal.RepeatingPlacement implements Internal.CountPlacementAccessor {
        static of($$0: Internal.IntProvider_): Internal.CountPlacement;
        static of($$0: number): Internal.CountPlacement;
        getCount(): Internal.IntProvider;
        get count(): Internal.IntProvider
        static readonly CODEC: Internal.Codec<Internal.CountPlacement>;
    }
    type CountPlacement_ = CountPlacement;
    interface LoggingEventBuilder {
        abstract addKeyValue(arg0: string, arg1: Internal.Supplier_<any>): this;
        abstract addMarker(arg0: org.slf4j.Marker_): this;
        abstract setMessage(arg0: Internal.Supplier_<string>): this;
        abstract log(arg0: string, ...arg1: any[]): void;
        abstract log(): void;
        abstract log(arg0: string, arg1: any): void;
        abstract addArgument(arg0: Internal.Supplier_<any>): this;
        abstract log(arg0: string, arg1: any, arg2: any): void;
        abstract setMessage(arg0: string): this;
        abstract addKeyValue(arg0: string, arg1: any): this;
        abstract log(arg0: string): void;
        abstract setCause(arg0: Internal.Throwable_): this;
        abstract log(arg0: Internal.Supplier_<string>): void;
        abstract addArgument(arg0: any): this;
        set message(arg0: Internal.Supplier_<string>)
        set message(arg0: string)
        set cause(arg0: Internal.Throwable_)
    }
    type LoggingEventBuilder_ = LoggingEventBuilder;
    class LoreBlockItem extends Internal.BlockItem {
        constructor(block: Internal.Block_, properties: Internal.Item$Properties_, ...lore: net.minecraft.network.chat.Component_[])
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type LoreBlockItem_ = LoreBlockItem;
    class NativeImage implements Internal.AutoCloseable, Internal.NativeImageAccessor, com.samsthenerd.inline.mixin.core.NativeImageAccessor, dev.tr7zw.skinlayers.accessor.NativeImageAccessor {
        constructor($$0: Internal.NativeImage$Format_, $$1: number, $$2: number, $$3: boolean)
        constructor($$0: number, $$1: number, $$2: boolean)
        applyToAllPixels($$0: Internal.IntUnaryOperator_): void;
        getPixelRGBA($$0: number, $$1: number): number;
        copyFrom($$0: Internal.NativeImage_): void;
        getPixelsRGBA(): number[];
        skinlayers$isAllocated(): boolean;
        copyRect($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: boolean, $$7: boolean): void;
        flipY(): void;
        getPointer(): number;
        static read($$0: Internal.InputStream_): Internal.NativeImage;
        downloadTexture($$0: number, $$1: boolean): void;
        getField_4988(): number;
        copyRect($$0: Internal.NativeImage_, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: boolean, $$8: boolean): void;
        setPixelLuminance($$0: number, $$1: number, $$2: number): void;
        writeToFile($$0: Internal.Path_): void;
        static read($$0: number[]): Internal.NativeImage;
        static read($$0: Internal.NativeImage$Format_, $$1: Internal.InputStream_): Internal.NativeImage;
        upload($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: boolean, $$8: boolean, $$9: boolean, $$10: boolean): void;
        upload($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: boolean, $$8: boolean): void;
        writeToFile($$0: Internal.File_): void;
        getHeight(): number;
        resizeSubRectTo($$0: number, $$1: number, $$2: number, $$3: number, $$4: Internal.NativeImage_): void;
        fillRect($$0: number, $$1: number, $$2: number, $$3: number, $$4: number): void;
        static read($$0: Internal.NativeImage$Format_, $$1: Internal.ByteBuffer_): Internal.NativeImage;
        untrack(): void;
        getGreenOrLuminance($$0: number, $$1: number): number;
        getWidth(): number;
        downloadDepthBuffer($$0: number): void;
        blendPixel($$0: number, $$1: number, $$2: number): void;
        copyFromFont($$0: Internal.STBTTFontinfo_, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: number, $$8: number, $$9: number): void;
        drawPixels(): void;
        getLuminanceOrAlpha($$0: number, $$1: number): number;
        getRedOrLuminance($$0: number, $$1: number): number;
        writeToChannel($$0: Internal.WritableByteChannel_): boolean;
        mappedCopy($$0: Internal.IntUnaryOperator_): this;
        getBlueOrLuminance($$0: number, $$1: number): number;
        format(): Internal.NativeImage$Format;
        upload($$0: number, $$1: number, $$2: number, $$3: boolean): void;
        close(): void;
        setPixelRGBA($$0: number, $$1: number, $$2: number): void;
        /**
         * @deprecated
        */
        makePixelArray(): number[];
        asByteArray(): number[];
        static read($$0: Internal.ByteBuffer_): Internal.NativeImage;
        get pixelsRGBA(): number[]
        get pointer(): number
        get field_4988(): number
        get height(): number
        get width(): number
        pixels: number;
    }
    type NativeImage_ = NativeImage;
    interface VibrationSystem {
        abstract getVibrationUser(): Internal.VibrationSystem$User;
        getGameEventFrequency($$0: Internal.GameEvent_): number;
        abstract getVibrationData(): Internal.VibrationSystem$Data;
        getRedstoneStrengthForDistance($$0: number, $$1: number): number;
        getResonanceEventByFrequency($$0: number): Internal.GameEvent;
        get vibrationUser(): Internal.VibrationSystem$User
        get vibrationData(): Internal.VibrationSystem$Data
        readonly VIBRATION_FREQUENCY_FOR_EVENT: {[key: Internal.GameEvent]: 5, [key: Internal.GameEvent]: 12, [key: Internal.GameEvent]: 8, [key: Internal.GameEvent]: 12, [key: Internal.GameEvent]: 9, [key: Internal.GameEvent]: 9, [key: Internal.GameEvent]: 11, [key: Internal.GameEvent]: 9, [key: Internal.GameEvent]: 1, [key: Internal.GameEvent]: 10, [key: Internal.GameEvent]: 10, [key: Internal.GameEvent]: 14, [key: Internal.GameEvent]: 15, [key: Internal.GameEvent]: 1, [key: Internal.GameEvent]: 9, [key: Internal.GameEvent]: 10, [key: Internal.GameEvent]: 6, [key: Internal.GameEvent]: 15, [key: Internal.GameEvent]: 3, [key: Internal.GameEvent]: 2, [key: Internal.GameEvent]: 1, [key: Internal.GameEvent]: 13, [key: Internal.GameEvent]: 6, [key: Internal.GameEvent]: 4, [key: Internal.GameEvent]: 4, [key: Internal.GameEvent]: 6, [key: Internal.GameEvent]: 3, [key: Internal.GameEvent]: 13, [key: Internal.GameEvent]: 10, [key: Internal.GameEvent]: 1, [key: Internal.GameEvent]: 4, [key: Internal.GameEvent]: 15, [key: Internal.GameEvent]: 14, [key: Internal.GameEvent]: 9, [key: Internal.GameEvent]: 2, [key: Internal.GameEvent]: 4, [key: Internal.GameEvent]: 7, [key: Internal.GameEvent]: 10, [key: Internal.GameEvent]: 12, [key: Internal.GameEvent]: 2, [key: Internal.GameEvent]: 10, [key: Internal.GameEvent]: 10, [key: Internal.GameEvent]: 11, [key: Internal.GameEvent]: 3, [key: Internal.GameEvent]: 8, [key: Internal.GameEvent]: 5, [key: Internal.GameEvent]: 3, [key: Internal.GameEvent]: 5, [key: Internal.GameEvent]: 13, [key: Internal.GameEvent]: 2, [key: Internal.GameEvent]: 6, [key: Internal.GameEvent]: 7, [key: Internal.GameEvent]: 14, [key: Internal.GameEvent]: 8, [key: Internal.GameEvent]: 14};
        readonly RESONANCE_EVENTS: Internal.GameEvent[];
    }
    type VibrationSystem_ = VibrationSystem;
    interface ExecutorService extends Internal.Executor, Internal.AutoCloseable {
        abstract invokeAny<T>(arg0: Internal.Collection_<Internal.Callable<T>>, arg1: number, arg2: Internal.TimeUnit_): T;
        abstract invokeAll<T>(arg0: Internal.Collection_<Internal.Callable<T>>, arg1: number, arg2: Internal.TimeUnit_): Internal.List<Internal.Future<T>>;
        abstract isShutdown(): boolean;
        abstract submit<T>(arg0: Internal.Callable_<T>): Internal.Future<T>;
        abstract shutdownNow(): Internal.List<Internal.Runnable>;
        abstract invokeAll<T>(arg0: Internal.Collection_<Internal.Callable<T>>): Internal.List<Internal.Future<T>>;
        abstract shutdown(): void;
        abstract awaitTermination(arg0: number, arg1: Internal.TimeUnit_): boolean;
        close(): void;
        abstract submit<T>(arg0: Internal.Runnable_, arg1: T): Internal.Future<T>;
        abstract invokeAny<T>(arg0: Internal.Collection_<Internal.Callable<T>>): T;
        abstract submit(arg0: Internal.Runnable_): Internal.Future<any>;
        abstract execute(arg0: Internal.Runnable_): void;
        abstract isTerminated(): boolean;
        get shutdown(): boolean
        get terminated(): boolean
    }
    type ExecutorService_ = ExecutorService;
    abstract class TamableAnimal extends Internal.Animal implements Internal.OwnableEntity {
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isOrderedToSit(): boolean;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getOwner(): Internal.LivingEntity;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        isInSittingPose(): boolean;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        setTame($$0: boolean): void;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        tame($$0: Internal.Player_): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        setInSittingPose($$0: boolean): void;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        setOwnerUUID($$0: Internal.UUID_): void;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        setOrderedToSit($$0: boolean): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        getOwnerUUID(): Internal.UUID;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        isTame(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        isOwnedBy($$0: Internal.LivingEntity_): boolean;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        level(): Internal.EntityGetter;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        wantsToAttack($$0: Internal.LivingEntity_, $$1: Internal.LivingEntity_): boolean;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get orderedToSit(): boolean
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get owner(): Internal.LivingEntity
        get inSittingPose(): boolean
        set tame($$0: boolean)
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        set inSittingPose($$0: boolean)
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        set ownerUUID($$0: Internal.UUID_)
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        set orderedToSit($$0: boolean)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get ownerUUID(): Internal.UUID
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get tame(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type TamableAnimal_ = TamableAnimal;
    class EventQueue {
        constructor()
        getNextEvent(): Internal.AWTEvent;
        static getMostRecentEventTime(): number;
        peekEvent(arg0: number): Internal.AWTEvent;
        static invokeAndWait(arg0: Internal.Runnable_): void;
        static isDispatchThread(): boolean;
        peekEvent(): Internal.AWTEvent;
        createSecondaryLoop(): Internal.SecondaryLoop;
        static invokeLater(arg0: Internal.Runnable_): void;
        push(arg0: Internal.EventQueue_): void;
        postEvent(arg0: Internal.AWTEvent_): void;
        static getCurrentEvent(): Internal.AWTEvent;
        get nextEvent(): Internal.AWTEvent
        get mostRecentEventTime(): number
        get dispatchThread(): boolean
        get currentEvent(): Internal.AWTEvent
    }
    type EventQueue_ = EventQueue;
    interface ChannelProgressivePromise extends Internal.ChannelProgressiveFuture, Internal.ChannelPromise, Internal.ProgressivePromise<void> {
        abstract awaitUninterruptibly(): this;
        abstract isSuccess(): boolean;
        abstract sync(): this;
        abstract addListeners(...arg0: Internal.GenericFutureListener_<io.netty.util.concurrent.Future<void>>[]): this;
        abstract await(): this;
        abstract trySuccess(): boolean;
        abstract tryFailure(arg0: Internal.Throwable_): boolean;
        abstract awaitUninterruptibly(arg0: number, arg1: Internal.TimeUnit_): boolean;
        abstract getNow(): void;
        abstract cause(): Internal.Throwable;
        abstract isVoid(): boolean;
        abstract await(arg0: number, arg1: Internal.TimeUnit_): boolean;
        abstract await(arg0: number): boolean;
        abstract setUncancellable(): boolean;
        abstract addListener(arg0: Internal.GenericFutureListener_<io.netty.util.concurrent.Future<void>>): this;
        exceptionNow(): Internal.Throwable;
        abstract awaitUninterruptibly(arg0: number): boolean;
        abstract get(arg0: number, arg1: Internal.TimeUnit_): void;
        abstract isCancelled(): boolean;
        state(): Internal.Future$State;
        abstract trySuccess(arg0: void): boolean;
        abstract removeListeners(...arg0: Internal.GenericFutureListener_<io.netty.util.concurrent.Future<void>>[]): this;
        abstract setProgress(arg0: number, arg1: number): this;
        abstract setSuccess(): this;
        abstract setSuccess(arg0: void): this;
        abstract unvoid(): this;
        resultNow(): void;
        abstract setFailure(arg0: Internal.Throwable_): this;
        abstract isDone(): boolean;
        abstract syncUninterruptibly(): this;
        abstract cancel(arg0: boolean): boolean;
        abstract channel(): io.netty.channel.Channel;
        abstract setSuccess(arg0: void): Internal.ProgressivePromise<void>;
        abstract removeListener(arg0: Internal.GenericFutureListener_<io.netty.util.concurrent.Future<void>>): this;
        abstract isCancellable(): boolean;
        abstract tryProgress(arg0: number, arg1: number): boolean;
        abstract get(): void;
        get success(): boolean
        get now(): void
        get "void"(): boolean
        get cancelled(): boolean
        set success(arg0: void)
        set failure(arg0: Internal.Throwable_)
        get done(): boolean
        set success(arg0: void)
        get cancellable(): boolean
    }
    type ChannelProgressivePromise_ = ChannelProgressivePromise;
    class FontManager implements Internal.AccessorFontManager, Internal.PreparableReloadListener, Internal.AutoCloseable, Internal.IdentifiableResourceReloadListener {
        constructor($$0: Internal.TextureManager_)
        setRenames($$0: Internal.Map_<ResourceLocation, ResourceLocation>): void;
        close(): void;
        getName(): string;
        getFabricDependencies(): Internal.Collection<ResourceLocation>;
        bookshelf$getFonts(): Internal.Map<any, any>;
        createFontFilterFishy(): net.minecraft.client.gui.Font;
        getFabricId(): ResourceLocation;
        reload($$0: Internal.PreparableReloadListener$PreparationBarrier_, $$1: Internal.ResourceManager_, $$2: Internal.ProfilerFiller_, $$3: Internal.ProfilerFiller_, $$4: Internal.Executor_, $$5: Internal.Executor_): Internal.CompletableFuture<void>;
        createFont(): net.minecraft.client.gui.Font;
        set renames($$0: Internal.Map_<ResourceLocation, ResourceLocation>)
        get name(): string
        get fabricDependencies(): Internal.Collection<ResourceLocation>
        get fabricId(): ResourceLocation
        readonly fontSets: Internal.Map<ResourceLocation, Internal.FontSet>;
        static readonly MISSING_FONT: ResourceLocation;
    }
    type FontManager_ = FontManager;
    class BlockItem extends Internal.Item implements Internal.BlockItemExtensions, Internal.IExtendedItem {
        constructor($$0: Internal.Block_, $$1: Internal.Item$Properties_)
        registerBlocks($$0: Internal.Map_<Internal.Block, Internal.Item>, $$1: Internal.Item_): void;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        static setBlockEntityData($$0: Internal.ItemStack_, $$1: Internal.BlockEntityType_<any>, $$2: Internal.CompoundTag_): void;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        static updateCustomBlockEntityTag($$0: Internal.Level_, $$1: Internal.Player_, $$2: BlockPos_, $$3: Internal.ItemStack_): boolean;
        static getBlockEntityData($$0: Internal.ItemStack_): Internal.CompoundTag;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        place($$0: Internal.BlockPlaceContext_): Internal.InteractionResult;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        getBlock(): Internal.Block;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        updatePlacementContext($$0: Internal.BlockPlaceContext_): Internal.BlockPlaceContext;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        get block(): Internal.Block
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly BLOCK_STATE_TAG: "BlockStateTag";
        static readonly BLOCK_ENTITY_TAG: "BlockEntityTag";
    }
    type BlockItem_ = BlockItem;
    interface InputReplacementTransformer {
        abstract transform(arg0: Internal.RecipeKJS_, arg1: Internal.ReplacementMatch_, arg2: Internal.InputReplacement_, arg3: Internal.InputReplacement_): any;
        (arg0: Internal.RecipeKJS, arg1: Internal.ReplacementMatch, arg2: Internal.InputReplacement, arg3: Internal.InputReplacement): any;
    }
    type InputReplacementTransformer_ = InputReplacementTransformer;
    class FlapDisplayLayout {
        constructor(maxCharCount: number)
        write(): Internal.CompoundTag;
        read(tag: Internal.CompoundTag_): void;
        configure(layoutKey: string, sections: Internal.List_<Internal.FlapDisplaySection>): void;
        getSections(): Internal.List<Internal.FlapDisplaySection>;
        loadDefault(maxCharCount: number): void;
        isLayout(key: string): boolean;
        get sections(): Internal.List<Internal.FlapDisplaySection>
    }
    type FlapDisplayLayout_ = FlapDisplayLayout;
    class ConnectorVariant extends Internal.Enum<Internal.ConnectorVariant> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static valueOf(name: string): Internal.ConnectorVariant;
        static values(): Internal.ConnectorVariant[];
        static test(level: Internal.Level_, pos: BlockPos_, face: Internal.Direction_): Internal.ConnectorVariant;
        get serializedName(): string
        static readonly Girder: Internal.ConnectorVariant;
        static readonly Default: Internal.ConnectorVariant;
    }
    type ConnectorVariant_ = "girder" | ConnectorVariant | "default";
    class ActionEvent extends Internal.AWTEvent {
        constructor(arg0: any, arg1: number, arg2: string, arg3: number, arg4: number)
        constructor(arg0: any, arg1: number, arg2: string)
        constructor(arg0: any, arg1: number, arg2: string, arg3: number)
        getModifiers(): number;
        getActionCommand(): string;
        getWhen(): number;
        get modifiers(): number
        get actionCommand(): string
        get when(): number
        static readonly ACTION_FIRST: 1001;
        static readonly ACTION_LAST: 1001;
        static readonly META_MASK: 4;
        static readonly ALT_MASK: 8;
        static readonly ACTION_PERFORMED: 1001;
        static readonly SHIFT_MASK: 1;
        static readonly CTRL_MASK: 2;
    }
    type ActionEvent_ = ActionEvent;
    class GantryShaftBlock extends Internal.DirectionalKineticBlock implements Internal.IBE<Internal.GantryShaftBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockEntityType(): Internal.BlockEntityType<Internal.GantryShaftBlockEntity>;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.GantryShaftBlockEntity>;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.GantryShaftBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.GantryShaftBlockEntity;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.GantryShaftBlockEntity>): void;
        showCapacityWithAnnotation(): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        getBlockEntityClass(): typeof Internal.GantryShaftBlockEntity;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockEntityType(): Internal.BlockEntityType<Internal.GantryShaftBlockEntity>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        get blockEntityClass(): typeof Internal.GantryShaftBlockEntity
        static readonly PART: Internal.Property<Internal.GantryShaftBlock$Part>;
        static readonly POWERED: Internal.BooleanProperty;
    }
    type GantryShaftBlock_ = GantryShaftBlock;
    class FossilFeature extends Internal.Feature<Internal.FossilFeatureConfiguration> {
        constructor($$0: Internal.Codec_<Internal.FossilFeatureConfiguration>)
    }
    type FossilFeature_ = FossilFeature;
    class OnionRingItem extends Internal.WearableArtifactItem {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        static applyMiningSpeedBuff(entity: Internal.LivingEntity_, properties: Internal.FoodProperties_): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        hasNonCosmeticEffects(): boolean;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type OnionRingItem_ = OnionRingItem;
    abstract class Entity implements Internal.Teleportable, Internal.IMixinEntity, Internal.BlockCachingEntity, net.blay09.mods.netherportalfix.mixin.EntityAccessor, com.simibubi.create.foundation.mixin.fabric.EntityAccessor, me.jellysquid.mods.lithium.mixin.block.hopper.EntityAccessor, me.alphamode.star.mixin.EntityAccessor, Internal.SophisticatedEntity, Internal.ComponentProvider, Internal.EntityAccessor, Internal.PehkuiEntityExtensions, Internal.ExtensionHolder, Internal.FluidCachingEntity, Internal.EntityExtensions, Internal.Nameable, Internal.ETFEntity, Internal.Cullable, Internal.CommandSource, dev.tr7zw.transition.mixin.EntityAccessor, Internal.EntityAccess, Internal.StarEntity, io.github.fabricators_of_create.porting_lib.entity.mixin.common.EntityAccessor, Internal.EntityKJS, io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.EntityAccessor, Internal.INBTSerializableCompound, dev.lambdaurora.lambdynlights.DynamicLightSource, Internal.AccessorEntity, net.fabricmc.fabric.impl.dimension.Teleportable, Internal.BalmEntity, Internal.AttachmentTargetImpl, net.darkhax.bookshelf.mixin.accessors.entity.AccessorEntity, at.petrak.hexcasting.mixin.accessor.AccessorEntity {
        constructor($$0: Internal.EntityType_<any>, $$1: Internal.Level_)
        litematica_setWorld(arg0: Internal.Level_): void;
        isInWall(): boolean;
        etf$getType(): Internal.EntityType<any>;
        getAllSlots(): Internal.Iterable<Internal.ItemStack>;
        getUpVector($$0: number): Vec3d;
        getXRot(): number;
        gameEvent($$0: Internal.GameEvent_, $$1: Internal.Entity_): void;
        remove($$0: Internal.Entity$RemovalReason_): void;
        isSuppressingBounce(): boolean;
        getBlockZ(): number;
        dampensVibrations(): boolean;
        hasAttached(type: Internal.AttachmentType_<any>): boolean;
        isSilent(): boolean;
        getPitch(): number;
        setCulled(value: boolean): void;
        isOnFire(): boolean;
        rotate($$0: Internal.Rotation_): number;
        getPositionCodec(): Internal.VecDeltaCodec;
        getPassengersAndSelf(): Internal.Stream<any>;
        "modifyExpressionValue$edk000$lib39-phantom$lib39Phantom$storeMutableForFluid"(mut: Internal.BlockPos$MutableBlockPos_): Internal.BlockPos$MutableBlockPos;
        updateFluidHeightAndDoFluidPushing($$0: Internal.TagKey_<Internal.Fluid>, $$1: number): boolean;
        setMaxUpStep($$0: number): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        chunkPosition(): Internal.ChunkPos;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        gameEvent($$0: Internal.GameEvent_): void;
        wrapWithCondition$hpi000$sophisticatedcore$sophisticatedCore$captureDrops(level: Internal.Level_, entity: Internal.Entity_): boolean;
        alwaysAccepts(): boolean;
        isShiftKeyDown(): boolean;
        setUUID($$0: Internal.UUID_): void;
        checkBelowWorld(): void;
        isVisuallyCrawling(): boolean;
        setMotionZ(z: number): void;
        canFreeze(): boolean;
        ignoreExplosion(): boolean;
        port_lib$setRemovalReason(arg0: Internal.Entity$RemovalReason_): void;
        teleportRelative($$0: number, $$1: number, $$2: number): void;
        getBlockY(): number;
        transition$setRawPosition(arg0: Vec3d_): void;
        isSpectator(): boolean;
        pehkui_setScaleCache(scaleCache: Internal.ScaleData_[]): void;
        isInWaterOrBubble(): boolean;
        spawnAtLocation($$0: Internal.ItemLike_, $$1: number): Internal.ItemEntity;
        getPersistentData(): Internal.CompoundTag;
        getPortalCooldown(): number;
        "handler$edk000$lib39-phantom$lib39Phantom$storeMutableForBlock"(ci: Internal.CallbackInfo_, mut: Internal.BlockPos$MutableBlockPos_): void;
        getItem(): Internal.ItemStack;
        causeFallDamage($$0: number, $$1: number, $$2: DamageSource_): boolean;
        getRandomZ($$0: number): number;
        pehkui_getOnGround(): boolean;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        setRemoved($$0: Internal.Entity$RemovalReason_): void;
        getPosition($$0: number): Vec3d;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getDistanceSq($$0: number, $$1: number, $$2: number): number;
        isInWaterRainOrBubble(): boolean;
        getRemovalReason(): Internal.Entity$RemovalReason;
        isIgnoringBlockTriggers(): boolean;
        etf$getItemsEquipped(): Internal.Iterable<any>;
        getHandHoldingItemAngle($$0: Internal.Item_): Vec3d;
        etf$getVelocity(): Vec3d;
        hex$markHurt(): void;
        distanceToSqr($$0: Vec3d_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        resetFallDistance(): void;
        canSprint(): boolean;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        blockPosition(): BlockPos;
        isSteppingCarefully(): boolean;
        setBoundingBox($$0: Internal.AABB_): void;
        isAmbientCreature(): boolean;
        /**
         * @deprecated
        */
        getLightLevelDependentMagicValue(): number;
        getBlockX(): number;
        getEncodeId(): string;
        getY($$0: number): number;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        etf$getHandItems(): Internal.Iterable<any>;
        setInvisible($$0: boolean): void;
        etf$getArmorItems(): Internal.Iterable<any>;
        getName(): net.minecraft.network.chat.Component;
        onGround(): boolean;
        sophisticatedInvalidateCaps(): void;
        getDynamicLightY(): number;
        getControlledVehicle(): this;
        isOnSameTeam($$0: Internal.Entity_): boolean;
        attack($$0: DamageSource_, $$1: number): boolean;
        onInsideBubbleColumn($$0: boolean): void;
        tick(): void;
        getEyePosition(): Vec3d;
        getEyeHeight(): number;
        hasPassenger($$0: Internal.Predicate_<Internal.Entity>): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getYaw(): number;
        getComponentContainer(): Internal.ComponentContainer;
        hasPermissions($$0: number): boolean;
        getDynamicLightPrevZ(): number;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        "handler$cda000$fabric-dimensions-v1$getTeleportTarget"(destination: Internal.ServerLevel_, cir: Internal.CallbackInfoReturnable_<any>): void;
        pehkui_readScaleNbt(nbt: Internal.CompoundTag_): void;
        setCustomNameVisible($$0: boolean): void;
        isAlliedTo($$0: Internal.Team_): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        setOutOfCamera(value: boolean): void;
        getRemainingFireTicks(): number;
        getControllingPassenger(): Internal.LivingEntity;
        wrapWithCondition$geb000$porting_lib_entity$port_lib$captureDrops(level: Internal.Level_, entity: Internal.Entity_): boolean;
        localvar$zni000$architectury$modifyLevelCallback_setLevelCallback(callback: Internal.EntityInLevelCallback_): Internal.EntityInLevelCallback;
        getScriptType(): Internal.ScriptType;
        onlyOpCanSetNbt(): boolean;
        startRiding($$0: Internal.Entity_): boolean;
        saveWithoutId($$0: Internal.CompoundTag_): Internal.CompoundTag;
        getForward(): Vec3d;
        serializeNBT(): Internal.Tag;
        fireImmune(): boolean;
        addMotion($$0: number, $$1: number, $$2: number): void;
        getMaxFallDistance(): number;
        getZ($$0: number): number;
        pehkui_isFirstUpdate(): boolean;
        getId(): number;
        canBeHitByProjectile(): boolean;
        getTicksFrozen(): number;
        getRecipientsForComponentSync(): Internal.Iterable<any>;
        getRandomX($$0: number): number;
        getDynamicLightZ(): number;
        getEyeY(): number;
        spawnAtLocation($$0: Internal.ItemStack_, $$1: number): Internal.ItemEntity;
        pick($$0: number, $$1: number, $$2: boolean): Internal.HitResult;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        fabric_readAttachmentsFromNbt(nbt: Internal.CompoundTag_): void;
        getBoundingBox(): Internal.AABB;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): this;
        isInWaterOrRain(): boolean;
        isDescending(): boolean;
        setItemSlot($$0: Internal.EquipmentSlot_, $$1: Internal.ItemStack_): void;
        getYHeadRot(): number;
        fabric_setCustomTeleportTarget(teleportTarget: Internal.PortalInfo_): void;
        getViewYRot($$0: number): number;
        dismountsUnderwater(): boolean;
        addTag($$0: string): boolean;
        playerTouch($$0: Internal.Player_): void;
        getEyeHeight($$0: Internal.Pose_): number;
        getAddEntityPacket(): Internal.Packet<Internal.ClientGamePacketListener>;
        syncPacketPositionCodec($$0: number, $$1: number, $$2: number): void;
        static port_lib$collideWithShapes$porting_lib_accessors_$md$fca01f$0(arg0: Vec3d_, arg1: Internal.AABB_, arg2: Internal.List_<any>): Vec3d;
        isTouchingUpsideDownFluid(): boolean;
        getTeam(): Internal.Team;
        shouldRenderAtSqrDistance($$0: number): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        damageSources(): Internal.DamageSources;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        setTicksFrozen($$0: number): void;
        recreateFromPacket($$0: Internal.ClientboundAddEntityPacket_): void;
        handler$geb000$porting_lib_entity$port_lib$removeRidingEntity(ci: Internal.CallbackInfo_): void;
        getMyRidingOffset(): number;
        dismountTo($$0: number, $$1: number, $$2: number): void;
        setDeltaMovement($$0: Vec3d_): void;
        getLeashOffset($$0: number): Vec3d;
        etf$getEntityKey(): string;
        etf$getPose(): Internal.Pose;
        captureDrops(): Internal.Collection<any>;
        hasCustomName(): boolean;
        isCulled(): boolean;
        isLiving(): boolean;
        getX(): number;
        isGlowing(): boolean;
        isVehicle(): boolean;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        etf$getOptifineId(): number;
        getLeashOffset(): Vec3d;
        resetDynamicLight(): void;
        isAttackable(): boolean;
        spawnAtLocation($$0: Internal.ItemStack_): Internal.ItemEntity;
        "handler$edk000$lib39-phantom$lib39Phantom$forgetMutableForFluid"(ci: Internal.CallbackInfoReturnable_<any>): void;
        mergeNbt(tag: Internal.CompoundTag_): this;
        thunderHit($$0: Internal.ServerLevel_, $$1: Internal.LightningBolt_): void;
        setIsInPowderSnow($$0: boolean): void;
        etf$distanceTo(entity: Internal.Entity_): number;
        doEnchantDamageEffects($$0: Internal.LivingEntity_, $$1: Internal.Entity_): void;
        setCustomName($$0: net.minecraft.network.chat.Component_): void;
        getSlot($$0: number): Internal.SlotAccess;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        pehkui_constructScaleData(type: Internal.ScaleType_): Internal.ScaleData;
        getTeamId(): string;
        stopSeenByPlayer($$0: Internal.ServerPlayer_): void;
        isUnderWater(): boolean;
        callGetSplashSound(): Internal.SoundEvent;
        stopRiding(): void;
        isCustomNameVisible(): boolean;
        isSupportedBy($$0: BlockPos_): boolean;
        iceandfire$setCustomTeleportTarget(teleportTarget: Internal.PortalInfo_): void;
        getX($$0: number): number;
        getPistonPushReaction(): Internal.PushReaction;
        lookAt($$0: Internal.EntityAnchorArgument$Anchor_, $$1: Vec3d_): void;
        getLuminance(): number;
        getSelfAndPassengers(): Internal.Stream<any>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getDeltaMovement(): Vec3d;
        collide($$0: Vec3d_): Vec3d;
        handler$geb000$porting_lib_entity$afterSave(nbt: Internal.CompoundTag_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getMotionX(): number;
        hasPassenger($$0: Internal.Entity_): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        hasIndirectPassenger($$0: Internal.Entity_): boolean;
        getDynamicLightX(): number;
        getEntityData(): Internal.SynchedEntityData;
        setSecondsOnFire($$0: number): void;
        moveTo($$0: number, $$1: number, $$2: number): void;
        handler$hpi000$sophisticatedcore$sophisticatedCore$saveAdditionalData(compound: Internal.CompoundTag_, cir: Internal.CallbackInfoReturnable_<any>): void;
        handleInsidePortal($$0: BlockPos_): void;
        setMotion($$0: number, $$1: number, $$2: number): void;
        playSound($$0: Internal.SoundEvent_): void;
        absMoveTo($$0: number, $$1: number, $$2: number): void;
        isOnRails(): boolean;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        restoreFrom($$0: Internal.Entity_): void;
        getDimensionChangingDelay(): number;
        isPeacefulCreature(): boolean;
        setOnGround($$0: boolean): void;
        getLastDynamicLuminance(): number;
        setYaw($$0: number): void;
        setPos($$0: number, $$1: number, $$2: number): void;
        getPickRadius(): number;
        getVehicle(): this;
        isEffectiveAi(): boolean;
        handler$eik000$lithium$tryShortcutFluidPushing(tag: Internal.TagKey_<any>, speed: number, cir: Internal.CallbackInfoReturnable_<any>, box: Internal.AABB_, x1: number, x2: number, y1: number, y2: number, z1: number, z2: number, zero: number): void;
        startRiding($$0: Internal.Entity_, $$1: boolean): boolean;
        getStringUuid(): string;
        isRemoved(): boolean;
        setSwimming($$0: boolean): void;
        teleportToWithTicket($$0: number, $$1: number, $$2: number): void;
        fillCrashReportCategory($$0: Internal.CrashReportCategory_): void;
        getRotationVector(): Internal.Vec2;
        pehkui_writeScaleNbt(nbt: Internal.CompoundTag_): Internal.CompoundTag;
        refreshDimensions(): void;
        self(): this;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        etf$getBlockY(): number;
        isSprinting(): boolean;
        getMotionY(): number;
        canCollideWith($$0: Internal.Entity_): boolean;
        setLuminance(luminance: number): void;
        getEyePosition($$0: number): Vec3d;
        setShiftKeyDown($$0: boolean): void;
        localvar$eol000$milk$clearEffectsInMilk(state: Internal.FluidState_): Internal.FluidState;
        getPassengers(): Internal.EntityArrayList;
        getBlockExplosionResistance($$0: Internal.Explosion_, $$1: Internal.BlockGetter_, $$2: BlockPos_, $$3: Internal.BlockState_, $$4: Internal.FluidState_, $$5: number): number;
        getZ(): number;
        getIsInsidePortal(): boolean;
        canSpawnSprintParticle(): boolean;
        teleportTo($$0: number, $$1: number, $$2: number): void;
        "modifyExpressionValue$edk000$lib39-phantom$lib39Phantom$replaceFluidStateForSubmerge"(in_: Internal.FluidState_): Internal.FluidState;
        handler$zbk000$porting_lib_base$port_lib$spawnSprintParticle(ci: Internal.CallbackInfo_, pos: BlockPos_, state: Internal.BlockState_): void;
        "modifyExpressionValue$edk001$lib39-phantom$lib39Phantom$replaceBlockState"(in_: Internal.BlockState_): Internal.BlockState;
        getServer(): Internal.MinecraftServer;
        moveRelative($$0: number, $$1: Vec3d_): void;
        getFirstPassenger(): this;
        saveAsPassenger($$0: Internal.CompoundTag_): boolean;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        interact($$0: Internal.Player_, $$1: Internal.InteractionHand_): Internal.InteractionResult;
        getDismountLocationForPassenger($$0: Internal.LivingEntity_): Vec3d;
        setXRot(arg0: number): void;
        invokeSetLevel(arg0: Internal.Level_): void;
        checkSlowFallDistance(): void;
        handler$hpi000$sophisticatedcore$sophisticatedCore$readAdditionalData(compound: Internal.CompoundTag_, ci: Internal.CallbackInfo_): void;
        setFabricBalmData(tag: Internal.CompoundTag_): void;
        getSoundSource(): Internal.SoundSource;
        getPose(): Internal.Pose;
        touchingUnloadedChunk(): boolean;
        handler$edd000$lambdynlights$onRemove(ci: Internal.CallbackInfo_): void;
        getLookAngle(): Vec3d;
        setPositionAndRotation($$0: number, $$1: number, $$2: number, $$3: number, $$4: number): void;
        getMotionZ(): number;
        etf$getUuid(): Internal.UUID;
        removeVehicle(): void;
        isInvisible(): boolean;
        is($$0: Internal.Entity_): boolean;
        setZ(z: number): void;
        getY(): number;
        ejectPassengers(): void;
        deserializeNBT(nbt: Internal.CompoundTag_): void;
        updateDynamicLightPreviousCoordinates(): void;
        getProfile(): Internal.GameProfile;
        static setViewScale($$0: number): void;
        modifyReturnValue$hmp000$create$onFireImmune(original: boolean): boolean;
        setLevelCallback($$0: Internal.EntityInLevelCallback_): void;
        showVehicleHealth(): boolean;
        getDistance(pos: BlockPos_): number;
        playSound($$0: Internal.SoundEvent_, $$1: number, $$2: number): void;
        getSophisticatedCustomData(): Internal.CompoundTag;
        etf$isBlockEntity(): boolean;
        startSeenByPlayer($$0: Internal.ServerPlayer_): void;
        isOnScoreboardTeam(teamId: string): boolean;
        isPushedByFluid(): boolean;
        position(): Vec3d;
        setTimeout(): void;
        displayFireAnimation(): boolean;
        turn($$0: number, $$1: number): void;
        isOutOfCamera(): boolean;
        getAirSupply(): number;
        getRopeHoldPosition($$0: number): Vec3d;
        copyPosition($$0: Internal.Entity_): void;
        etf$canBeBright(): boolean;
        isCrouching(): boolean;
        moveTo($$0: BlockPos_, $$1: number, $$2: number): void;
        isPlayer(): boolean;
        isAnimal(): boolean;
        canBeCollidedWith(): boolean;
        getMotionDirection(): Internal.Direction;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        lavaHurt(): void;
        getFeetBlockState(): Internal.BlockState;
        handleDamageEvent($$0: DamageSource_): void;
        getFabricBalmData(): Internal.CompoundTag;
        canChangeDimensions(): boolean;
        getChangeListener(): Internal.EntityInLevelCallback;
        static tickEntity(entity: Internal.Entity_): void;
        getCommandSenderWorld(): Internal.Level;
        positionRider($$0: Internal.Entity_): void;
        baseTick(): void;
        broadcastToPlayer($$0: Internal.ServerPlayer_): boolean;
        changeDimension($$0: Internal.ServerLevel_): this;
        getCustomName(): net.minecraft.network.chat.Component;
        pehkui_shouldIgnoreScaleNbt(): boolean;
        getMaxAirSupply(): number;
        isVisuallySwimming(): boolean;
        attack(hp: number): void;
        handler$hig000$star$upsideDownFluidCheck(cir: Internal.CallbackInfoReturnable_<any>): void;
        dynamicLightTick(): void;
        getFacing(): Internal.Direction;
        getDimensions($$0: Internal.Pose_): Internal.EntityDimensions;
        isPassengerOfSameVehicle($$0: Internal.Entity_): boolean;
        getBoundingBoxForCulling(): Internal.AABB;
        isSwimming(): boolean;
        mayInteract($$0: Internal.Level_, $$1: BlockPos_): boolean;
        static collideBoundingBox(entity: Internal.Entity_, movement: Vec3d_, entityBoundingBox: Internal.AABB_, world: Internal.Level_, collisions: Internal.List_<any>): Vec3d;
        setSprinting($$0: boolean): void;
        getDynamicLightLevel(): Internal.Level;
        setPortalCooldown(): void;
        setX(x: number): void;
        trackingPosition(): Vec3d;
        getNameTagOffsetY(): number;
        isInvulnerable(): boolean;
        sophisticatedCaptureDrops(value: Internal.Collection_<any>): Internal.Collection<any>;
        isInLava(): boolean;
        getBlockStateOn(): Internal.BlockState;
        isInWater(): boolean;
        awardKillScore($$0: Internal.Entity_, $$1: number, $$2: DamageSource_): void;
        getPortalWaitTime(): number;
        getFluidJumpThreshold(): number;
        pehkui_getScaleCache(): Internal.ScaleData[];
        isInvisibleTo($$0: Internal.Player_): boolean;
        setAirSupply($$0: number): void;
        getOnPos(): BlockPos;
        getRootVehicle(): this;
        etf$getWorld(): Internal.Level;
        save($$0: Internal.CompoundTag_): boolean;
        pehkui_getScales(): Internal.Map<any, any>;
        getBlockPosBelowThatAffectsMyMovement(): BlockPos;
        isNoGravity(): boolean;
        etf$getNbt(): Internal.CompoundTag;
        modifyExpressionValue$hmp000$create$playerHidingAsBoxIsCrouchingNotSwimming(original: boolean, pose: Internal.Pose_): boolean;
        acceptsFailure(): boolean;
        etf$getBlockPos(): BlockPos;
        pehkui_setShouldIgnoreScaleNbt(ignore: boolean): void;
        setOnGroundWithKnownMovement($$0: boolean, $$1: Vec3d_): void;
        setOldPosAndRot(): void;
        modifyReturnValue$bab000$arsenal$preventStunnedMobsFromTargeting(original: boolean): boolean;
        bookshelf$createHoverEvent(): Internal.HoverEvent;
        isFree($$0: number, $$1: number, $$2: number): boolean;
        updateSwimming(): void;
        setRemainingFireTicks($$0: number): void;
        getCachedFeetBlockState(): Internal.BlockState;
        shouldInformAdmins(): boolean;
        rideTick(): void;
        etf$hasCustomName(): boolean;
        /**
         * @deprecated
        */
        getOnPosLegacy(): BlockPos;
        setPos($$0: Vec3d_): void;
        getUuid(): Internal.UUID;
        spawn(): void;
        teleportTo($$0: Internal.ServerLevel_, $$1: number, $$2: number, $$3: number, $$4: Internal.Set_<Internal.RelativeMovement>, $$5: number, $$6: number): boolean;
        etf$getCustomName(): net.minecraft.network.chat.Component;
        captureDrops(value: Internal.Collection_<any>): Internal.Collection<any>;
        fabric_writeAttachmentsToNbt(nbt: Internal.CompoundTag_): void;
        shouldShowName(): boolean;
        getArmorSlots(): Internal.Iterable<Internal.ItemStack>;
        setSilent($$0: boolean): void;
        hasExactlyOnePlayerPassenger(): boolean;
        kill(): void;
        isOnPortalCooldown(): boolean;
        animateHurt($$0: number): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        lambdynlights$setTrackedLitChunkPos(trackedLitChunkPos: Internal.LongSet_): void;
        setPitch($$0: number): void;
        callGetEyeHeight(arg0: Internal.Pose_, arg1: Internal.EntityDimensions_): number;
        setPosRaw($$0: number, $$1: number, $$2: number): void;
        handleEntityEvent($$0: number): void;
        setExtension(key: any, value: any): void;
        isAlwaysTicking(): boolean;
        interactAt($$0: Internal.Player_, $$1: Vec3d_, $$2: Internal.InteractionHand_): Internal.InteractionResult;
        deserializeNBT(arg0: Internal.Tag_): void;
        lerpTo($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: boolean): void;
        onPassengerTurned($$0: Internal.Entity_): void;
        spawnAtLocation($$0: Internal.ItemLike_): Internal.ItemEntity;
        handler$geb000$porting_lib_entity$port_lib$onEntityRemove(reason: Internal.Entity$RemovalReason_, ci: Internal.CallbackInfo_): void;
        setAttached(type: Internal.AttachmentType_<any>, value: any): any;
        getBbWidth(): number;
        port_lib$getEntityString(): string;
        addDeltaMovement($$0: Vec3d_): void;
        pehkui_setOnGround(onGround: boolean): void;
        lithiumOnBlockCacheDeleted(): void;
        setInvulnerable($$0: boolean): void;
        push($$0: Internal.Entity_): void;
        mirror($$0: Internal.Mirror_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        getTicksRequiredToFreeze(): number;
        getDynamicLightPrevY(): number;
        maxUpStep(): number;
        catnip$callSetLevel(arg0: Internal.Level_): void;
        setGlowing($$0: boolean): void;
        getYRot(): number;
        load($$0: Internal.CompoundTag_): void;
        "modifyExpressionValue$edk000$lib39-phantom$lib39Phantom$replaceBlockStateForSuffocation"(in_: Internal.BlockState_, box: Internal.AABB_, pos: BlockPos_): Internal.BlockState;
        isAlive(): boolean;
        getBbHeight(): number;
        getUsername(): string;
        transition$getRawPosition(): Vec3d;
        move($$0: Internal.MoverType_, $$1: Vec3d_): void;
        getTags(): Internal.Set<string>;
        getViewVector($$0: number): Vec3d;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        isPickable(): boolean;
        setYHeadRot($$0: number): void;
        hasControllingPassenger(): boolean;
        closerThan($$0: Internal.Entity_, $$1: number, $$2: number): boolean;
        absMoveTo($$0: number, $$1: number, $$2: number, $$3: number, $$4: number): void;
        getCustomData(): Internal.CompoundTag;
        getPercentFrozen(): number;
        getPickResult(): Internal.ItemStack;
        setPortalCooldown($$0: number): void;
        getRandomY(): number;
        getDisplayName(): net.minecraft.network.chat.Component;
        hasGlowingTag(): boolean;
        shouldBlockExplode($$0: Internal.Explosion_, $$1: Internal.BlockGetter_, $$2: BlockPos_, $$3: Internal.BlockState_, $$4: number): boolean;
        setPosition(block: Internal.BlockContainerJS_): void;
        getDynamicLightPrevX(): number;
        handler$deg001$iceandfire$getTeleportTarget(destination: Internal.ServerLevel_, cir: Internal.CallbackInfoReturnable_<any>): void;
        shouldBeSaved(): boolean;
        fabric_hasPersistentAttachments(): boolean;
        handler$geb000$porting_lib_entity$afterLoad(nbt: Internal.CompoundTag_, ci: Internal.CallbackInfo_): void;
        getViewXRot($$0: number): number;
        canRiderInteract(): boolean;
        fabric_getAttachments(): Internal.Map<any, any>;
        removeTag($$0: string): boolean;
        callGetHighSpeedSplashSound(): Internal.SoundEvent;
        setPose($$0: Internal.Pose_): void;
        getFluidHeight($$0: Internal.TagKey_<Internal.Fluid>): number;
        getEntityType(): Internal.EntityType<any>;
        isWaterCreature(): boolean;
        pehkui_getScaleData(type: Internal.ScaleType_): Internal.ScaleData;
        getPassengersRidingOffset(): number;
        etf$getScoreboardTeam(): Internal.Team;
        distanceToEntitySqr($$0: Internal.Entity_): number;
        setYRot(arg0: number): void;
        isFrame(): boolean;
        discard(): void;
        isPushable(): boolean;
        setYBodyRot($$0: number): void;
        onClientRemoval(): void;
        sendSystemMessage($$0: net.minecraft.network.chat.Component_): void;
        acceptsSuccess(): boolean;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        setNoGravity($$0: boolean): void;
        getAttached(type: Internal.AttachmentType_<any>): any;
        getIndirectPassengers(): Internal.Iterable<any>;
        setRotation(yaw: number, pitch: number): void;
        "modifyExpressionValue$edk000$lib39-phantom$lib39Phantom$replaceFluidStateForTouch"(in_: Internal.FluidState_): Internal.FluidState;
        isDynamicLightEnabled(): boolean;
        createCommandSourceStack(): Internal.CommandSourceStack;
        isControlledByLocalInstance(): boolean;
        isMonster(): boolean;
        pehkui_setShouldSyncScales(sync: boolean): void;
        setLastDynamicLuminance(luminance: number): void;
        setId($$0: number): void;
        getHorizontalFacing(): Internal.Direction;
        onSyncedDataUpdated($$0: Internal.List_<Internal.SynchedEntityData$DataValue<any>>): void;
        getType(): string;
        getLightProbePosition($$0: number): Vec3d;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        onAboveBubbleCol($$0: boolean): void;
        toComponentPacket(key: Internal.ComponentKey_<any>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        isPassenger(): boolean;
        hasPose($$0: Internal.Pose_): boolean;
        checkDespawn(): void;
        pehkui_shouldSyncScales(): boolean;
        makeStuckInBlock($$0: Internal.BlockState_, $$1: Vec3d_): void;
        isInvulnerableTo($$0: DamageSource_): boolean;
        isEyeInFluid($$0: Internal.TagKey_<Internal.Fluid>): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        skipAttackInteraction($$0: Internal.Entity_): boolean;
        "handler$edk000$lib39-phantom$lib39Phantom$forgetMutableForBlock"(ci: Internal.CallbackInfo_): void;
        lerpMotion($$0: number, $$1: number, $$2: number): void;
        shouldRender($$0: number, $$1: number, $$2: number): boolean;
        onSyncedDataUpdated($$0: Internal.EntityDataAccessor_<any>): void;
        lerpHeadTo($$0: number, $$1: number): void;
        handler$geb000$porting_lib_entity$port_lib$startRiding(entity: Internal.Entity_, bl: boolean, cir: Internal.CallbackInfoReturnable_<any>): void;
        static getViewScale(): number;
        setMotionX(x: number): void;
        getHandSlots(): Internal.Iterable<Internal.ItemStack>;
        distanceToEntity($$0: Internal.Entity_): number;
        getVisualRotationYInDegrees(): number;
        handler$hig000$star$fixReturn(cir: Internal.CallbackInfoReturnable_<any>): void;
        getTeamColor(): number;
        isDiscrete(): boolean;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        unRide(): void;
        getLevel(): Internal.Level;
        lambdynlights$getTrackedLitChunkPos(): Internal.LongSet;
        extinguish(): void;
        setDynamicLightEnabled(enabled: boolean): void;
        updateDynamicGameEventListener($$0: Internal.BiConsumer_<Internal.DynamicGameEventListener<any>, Internal.ServerLevel>): void;
        moveTo($$0: Vec3d_): void;
        getExtension(key: any, type: typeof any): any;
        isColliding($$0: BlockPos_, $$1: Internal.BlockState_): boolean;
        sophisticatedCaptureDrops(): Internal.Collection<any>;
        extinguishFire(): void;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        isForcedVisible(): boolean;
        closerThan($$0: Internal.Entity_, $$1: number): boolean;
        "handler$hjd000$step-height-entity-attribute$getStepHeight"(cir: Internal.CallbackInfoReturnable_<any>): void;
        getDistanceSq(pos: BlockPos_): number;
        killedEntity($$0: Internal.ServerLevel_, $$1: Internal.LivingEntity_): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        isFreezing(): boolean;
        isFullyFrozen(): boolean;
        runCommand(command: string): number;
        setSharedFlagOnFire($$0: boolean): void;
        get inWall(): boolean
        get allSlots(): Internal.Iterable<Internal.ItemStack>
        get XRot(): number
        get suppressingBounce(): boolean
        get blockZ(): number
        get silent(): boolean
        get pitch(): number
        set culled(value: boolean)
        get onFire(): boolean
        get positionCodec(): Internal.VecDeltaCodec
        get passengersAndSelf(): Internal.Stream<any>
        set maxUpStep($$0: number)
        get shiftKeyDown(): boolean
        set UUID($$0: Internal.UUID_)
        get visuallyCrawling(): boolean
        set motionZ(z: number)
        get blockY(): number
        get spectator(): boolean
        get inWaterOrBubble(): boolean
        get persistentData(): Internal.CompoundTag
        get portalCooldown(): number
        get item(): Internal.ItemStack
        set removed($$0: Internal.Entity$RemovalReason_)
        get inWaterRainOrBubble(): boolean
        get removalReason(): Internal.Entity$RemovalReason
        get ignoringBlockTriggers(): boolean
        get steppingCarefully(): boolean
        set boundingBox($$0: Internal.AABB_)
        get ambientCreature(): boolean
        /**
         * @deprecated
        */
        get lightLevelDependentMagicValue(): number
        get blockX(): number
        get encodeId(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        set invisible($$0: boolean)
        get name(): net.minecraft.network.chat.Component
        get dynamicLightY(): number
        get controlledVehicle(): Internal.Entity
        get eyePosition(): Vec3d
        get eyeHeight(): number
        get yaw(): number
        get componentContainer(): Internal.ComponentContainer
        get dynamicLightPrevZ(): number
        set customNameVisible($$0: boolean)
        set outOfCamera(value: boolean)
        get remainingFireTicks(): number
        get controllingPassenger(): Internal.LivingEntity
        get scriptType(): Internal.ScriptType
        get forward(): Vec3d
        get maxFallDistance(): number
        get id(): number
        get ticksFrozen(): number
        get recipientsForComponentSync(): Internal.Iterable<any>
        get dynamicLightZ(): number
        get eyeY(): number
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get boundingBox(): Internal.AABB
        get inWaterOrRain(): boolean
        get descending(): boolean
        get YHeadRot(): number
        get addEntityPacket(): Internal.Packet<Internal.ClientGamePacketListener>
        get touchingUpsideDownFluid(): boolean
        get team(): Internal.Team
        set ticksFrozen($$0: number)
        get myRidingOffset(): number
        set deltaMovement($$0: Vec3d_)
        get culled(): boolean
        get living(): boolean
        get x(): number
        get glowing(): boolean
        get vehicle(): boolean
        get leashOffset(): Vec3d
        get attackable(): boolean
        set isInPowderSnow($$0: boolean)
        set customName($$0: net.minecraft.network.chat.Component_)
        get teamId(): string
        get underWater(): boolean
        get customNameVisible(): boolean
        get pistonPushReaction(): Internal.PushReaction
        get luminance(): number
        get selfAndPassengers(): Internal.Stream<any>
        get deltaMovement(): Vec3d
        get motionX(): number
        get dynamicLightX(): number
        get entityData(): Internal.SynchedEntityData
        set secondsOnFire($$0: number)
        get onRails(): boolean
        get dimensionChangingDelay(): number
        get peacefulCreature(): boolean
        set onGround($$0: boolean)
        get lastDynamicLuminance(): number
        set yaw($$0: number)
        get pickRadius(): number
        get vehicle(): Internal.Entity
        get effectiveAi(): boolean
        get stringUuid(): string
        get removed(): boolean
        set swimming($$0: boolean)
        get rotationVector(): Internal.Vec2
        get touchingFluid(): Internal.FluidState
        get sprinting(): boolean
        get motionY(): number
        set luminance(luminance: number)
        set shiftKeyDown($$0: boolean)
        get passengers(): Internal.EntityArrayList
        get z(): number
        get isInsidePortal(): boolean
        get server(): Internal.MinecraftServer
        get firstPassenger(): Internal.Entity
        set XRot(arg0: number)
        set fabricBalmData(tag: Internal.CompoundTag_)
        get soundSource(): Internal.SoundSource
        get pose(): Internal.Pose
        get lookAngle(): Vec3d
        get motionZ(): number
        get invisible(): boolean
        set z(z: number)
        get y(): number
        get profile(): Internal.GameProfile
        set viewScale($$0: number)
        set levelCallback($$0: Internal.EntityInLevelCallback_)
        get sophisticatedCustomData(): Internal.CompoundTag
        get pushedByFluid(): boolean
        get outOfCamera(): boolean
        get airSupply(): number
        get crouching(): boolean
        get player(): boolean
        get animal(): boolean
        get motionDirection(): Internal.Direction
        set y(y: number)
        get feetBlockState(): Internal.BlockState
        get fabricBalmData(): Internal.CompoundTag
        get changeListener(): Internal.EntityInLevelCallback
        get commandSenderWorld(): Internal.Level
        get customName(): net.minecraft.network.chat.Component
        get maxAirSupply(): number
        get visuallySwimming(): boolean
        get facing(): Internal.Direction
        get boundingBoxForCulling(): Internal.AABB
        get swimming(): boolean
        set sprinting($$0: boolean)
        get dynamicLightLevel(): Internal.Level
        set x(x: number)
        get nameTagOffsetY(): number
        get invulnerable(): boolean
        get inLava(): boolean
        get blockStateOn(): Internal.BlockState
        get inWater(): boolean
        get portalWaitTime(): number
        get fluidJumpThreshold(): number
        set airSupply($$0: number)
        get onPos(): BlockPos
        get rootVehicle(): Internal.Entity
        get blockPosBelowThatAffectsMyMovement(): BlockPos
        get noGravity(): boolean
        set remainingFireTicks($$0: number)
        get cachedFeetBlockState(): Internal.BlockState
        /**
         * @deprecated
        */
        get onPosLegacy(): BlockPos
        set pos($$0: Vec3d_)
        get uuid(): Internal.UUID
        get armorSlots(): Internal.Iterable<Internal.ItemStack>
        set silent($$0: boolean)
        get onPortalCooldown(): boolean
        set pitch($$0: number)
        get alwaysTicking(): boolean
        get bbWidth(): number
        set invulnerable($$0: boolean)
        get ticksRequiredToFreeze(): number
        get dynamicLightPrevY(): number
        set glowing($$0: boolean)
        get YRot(): number
        get alive(): boolean
        get bbHeight(): number
        get username(): string
        get tags(): Internal.Set<string>
        get pickable(): boolean
        set YHeadRot($$0: number)
        get customData(): Internal.CompoundTag
        get percentFrozen(): number
        get pickResult(): Internal.ItemStack
        set portalCooldown($$0: number)
        get randomY(): number
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        get dynamicLightPrevX(): number
        set pose($$0: Internal.Pose_)
        get entityType(): Internal.EntityType<any>
        get waterCreature(): boolean
        get passengersRidingOffset(): number
        set YRot(arg0: number)
        get frame(): boolean
        get pushable(): boolean
        set YBodyRot($$0: number)
        set motionY(y: number)
        set noGravity($$0: boolean)
        get indirectPassengers(): Internal.Iterable<any>
        get dynamicLightEnabled(): boolean
        get controlledByLocalInstance(): boolean
        get monster(): boolean
        set lastDynamicLuminance(luminance: number)
        set id($$0: number)
        get horizontalFacing(): Internal.Direction
        get type(): string
        get passenger(): boolean
        get viewScale(): number
        set motionX(x: number)
        get handSlots(): Internal.Iterable<Internal.ItemStack>
        get visualRotationYInDegrees(): number
        get teamColor(): number
        get discrete(): boolean
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        set dynamicLightEnabled(enabled: boolean)
        get forcedVisible(): boolean
        get freezing(): boolean
        get fullyFrozen(): boolean
        set sharedFlagOnFire($$0: boolean)
        xRotO: number;
        static readonly UUID_TAG: "UUID";
        static readonly DEFAULT_BB_WIDTH: 0.6;
        yOld: number;
        static readonly DELTA_AFFECTED_BY_BLOCKS_BELOW_0_2: 0.2;
        wasInPowderSnow: boolean;
        verticalCollision: boolean;
        static readonly FREEZE_HURT_FREQUENCY: 40;
        static readonly BASE_TICKS_REQUIRED_TO_FREEZE: 140;
        verticalCollisionBelow: boolean;
        static readonly TOTAL_AIR_SUPPLY: 300;
        xRot: number;
        zOld: number;
        fallDistance: number;
        static readonly BREATHING_DISTANCE_BELOW_EYES: 0.11111111;
        blocksBuilding: boolean;
        walkDist: number;
        noCulling: boolean;
        static readonly PASSENGERS_TAG: "Passengers";
        hurtMarked: boolean;
        isInPowderSnow: boolean;
        wasEyeInWater: boolean;
        static readonly MAX_ENTITY_TAG_COUNT: 1024;
        age: number;
        yo: number;
        xo: number;
        zo: number;
        invulnerableTime: number;
        horizontalCollision: boolean;
        yRotO: number;
        readonly random: Internal.RandomSource;
        level: Internal.Level;
        wasOnFire: boolean;
        static readonly DELTA_AFFECTED_BY_BLOCKS_BELOW_0_5: 0.500001;
        static readonly DELTA_AFFECTED_BY_BLOCKS_BELOW_1_0: 0.999999;
        flyDist: number;
        static readonly WATER_FLOW_SCALE: 0.014;
        mainSupportingBlockPos: Internal.Optional<BlockPos>;
        static readonly BOARDING_COOLDOWN: 60;
        static readonly DEFAULT_BB_HEIGHT: 1.8;
        hasImpulse: boolean;
        minorHorizontalCollision: boolean;
        xOld: number;
        moveDist: number;
        yRot: number;
        walkDistO: number;
        noPhysics: boolean;
        static readonly ID_TAG: "id";
    }
    type Entity_ = Entity;
    class ClientboundRespawnPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.ResourceKey_<Internal.DimensionType>, $$1: Internal.ResourceKey_<Internal.Level>, $$2: number, $$3: Internal.GameType_, $$4: Internal.GameType_, $$5: boolean, $$6: boolean, $$7: number, $$8: Internal.Optional_<Internal.GlobalPos>, $$9: number)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        getPortalCooldown(): number;
        getSeed(): number;
        getPlayerGameType(): Internal.GameType;
        getLastDeathLocation(): Internal.Optional<Internal.GlobalPos>;
        isSkippable(): boolean;
        shouldKeep($$0: number): boolean;
        getDimension(): Internal.ResourceKey<Internal.Level>;
        getDimensionType(): Internal.ResourceKey<Internal.DimensionType>;
        getPreviousPlayerGameType(): Internal.GameType;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isFlat(): boolean;
        isDebug(): boolean;
        get portalCooldown(): number
        get seed(): number
        get playerGameType(): Internal.GameType
        get lastDeathLocation(): Internal.Optional<Internal.GlobalPos>
        get skippable(): boolean
        get dimension(): Internal.ResourceKey<Internal.Level>
        get dimensionType(): Internal.ResourceKey<Internal.DimensionType>
        get previousPlayerGameType(): Internal.GameType
        get flat(): boolean
        get debug(): boolean
        static readonly KEEP_ENTITY_DATA: 2;
        static readonly KEEP_ALL_DATA: 3;
        static readonly KEEP_ATTRIBUTES: 1;
    }
    type ClientboundRespawnPacket_ = ClientboundRespawnPacket;
    interface IGeneratedBlockState {
        abstract toJson(): Internal.JsonObject;
        (): Internal.JsonObject_;
    }
    type IGeneratedBlockState_ = IGeneratedBlockState;
    interface TagsProvider$TagLookup <T> extends Internal.Function<Internal.TagKey<T>, Internal.Optional<Internal.TagBuilder>> {
        andThen<V>(arg0: Internal.Function_<Internal.Optional<Internal.TagBuilder>, V>): Internal.Function<Internal.TagKey<T>, V>;
        compose<V>(arg0: Internal.Function_<V, Internal.TagKey<T>>): Internal.Function<V, Internal.Optional<Internal.TagBuilder>>;
        contains($$0: Internal.TagKey_<T>): boolean;
        empty<T>(): this;
        abstract apply(arg0: Internal.TagKey_<T>): Internal.Optional<Internal.TagBuilder>;
        identity<T>(): Internal.Function<T, T>;
        (arg0: Internal.TagKey<T>): Internal.Optional_<Internal.TagBuilder>;
    }
    type TagsProvider$TagLookup_<T> = TagsProvider$TagLookup<T>;
    class Schema {
        constructor(arg0: number, arg1: Internal.Schema_)
        getParent(): this;
        register(arg0: Internal.Map_<string, Internal.Supplier<Internal.TypeTemplate>>, arg1: string, arg2: Internal.Supplier_<Internal.TypeTemplate>): void;
        getType(arg0: Internal.DSL$TypeReference_): com.mojang.datafixers.types.Type<any>;
        registerSimple(arg0: Internal.Map_<string, Internal.Supplier<Internal.TypeTemplate>>, arg1: string): void;
        types(): Internal.Set<string>;
        registerEntities(arg0: Internal.Schema_): Internal.Map<string, Internal.Supplier<Internal.TypeTemplate>>;
        getVersionKey(): number;
        getTypeRaw(arg0: Internal.DSL$TypeReference_): com.mojang.datafixers.types.Type<any>;
        registerTypes(arg0: Internal.Schema_, arg1: Internal.Map_<string, Internal.Supplier<Internal.TypeTemplate>>, arg2: Internal.Map_<string, Internal.Supplier<Internal.TypeTemplate>>): void;
        registerType(arg0: boolean, arg1: Internal.DSL$TypeReference_, arg2: Internal.Supplier_<Internal.TypeTemplate>): void;
        resolveTemplate(arg0: string): Internal.TypeTemplate;
        getChoiceType(arg0: Internal.DSL$TypeReference_, arg1: string): com.mojang.datafixers.types.Type<any>;
        register(arg0: Internal.Map_<string, Internal.Supplier<Internal.TypeTemplate>>, arg1: string, arg2: Internal.Function_<string, Internal.TypeTemplate>): void;
        registerBlockEntities(arg0: Internal.Schema_): Internal.Map<string, Internal.Supplier<Internal.TypeTemplate>>;
        id(arg0: string): Internal.TypeTemplate;
        findChoiceType(arg0: Internal.DSL$TypeReference_): Internal.TaggedChoice$TaggedChoiceType<any>;
        get parent(): Internal.Schema
        get versionKey(): number
    }
    type Schema_ = Schema;
    interface EncasableBlock {
        playEncaseSound(level: Internal.Level_, pos: BlockPos_): void;
        tryEncase(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, heldItem: Internal.ItemStack_, player: Internal.Player_, hand: Internal.InteractionHand_, ray: Internal.BlockHitResult_): Internal.InteractionResult;
    }
    type EncasableBlock_ = EncasableBlock;
    abstract class EncodedPatternItem extends Internal.AEBaseItem implements Internal.AEToolItem {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        abstract decode(arg0: Internal.AEItemKey_, arg1: Internal.Level_): Internal.IPatternDetails;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        abstract decode(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: boolean): Internal.IPatternDetails;
        getOutput(item: Internal.ItemStack_): Internal.ItemStack;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type EncodedPatternItem_ = EncodedPatternItem;
    interface ServerGamePacketListenerImplAccessor {
        abstract create$setAboveGroundVehicleTickCount(arg0: number): void;
        abstract create$setAboveGroundTickCount(arg0: number): void;
    }
    type ServerGamePacketListenerImplAccessor_ = ServerGamePacketListenerImplAccessor;
    class FakePlayer extends Internal.ServerPlayer {
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        getDistance(pos: BlockPos_): number;
        isFake(): boolean;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        getStats(): Internal.PlayerStatsJS;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        abstract etf$getType(): Internal.EntityType<any>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        getSpawnLocation(): Internal.BlockContainerJS;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        static get(world: Internal.ServerLevel_, profile: Internal.GameProfile_): Internal.FakePlayer;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        addFood(f: number, m: number): void;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        setSpawnLocation(c: Internal.BlockContainerJS_): void;
        captureInventory(autoRestore: boolean): net.minecraft.world.Container;
        swing(): void;
        getEntityReach(): number;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        getXpLevel(): number;
        canReach(pos: BlockPos_, padding: number): boolean;
        clearMeshes(): void;
        openGUI(gui: Internal.Consumer_<Internal.KubeJSGUI>): void;
        setSelectedSlot(index: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        isOp(): boolean;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        kick(): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        paint(renderer: Internal.CompoundTag_): void;
        getBlockReach(): number;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getAnimation(): Internal.AnimationApplier;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getFoodLevel(): number;
        openChestGUI(title: net.minecraft.network.chat.Component_, rows: number, gui: Internal.Consumer_<Internal.ChestMenuData>): void;
        notify(title: net.minecraft.network.chat.Component_, text: net.minecraft.network.chat.Component_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        setXpLevel(l: number): void;
        canRiderInteract(): boolean;
        setFoodLevel(foodLevel: number): void;
        setSaturation(saturation: number): void;
        addXPLevels(l: number): void;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        canReach(entity: Internal.Entity_, padding: number): boolean;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        abstract etf$getArmorItems(): Internal.Iterable<Internal.ItemStack>;
        sendData(channel: string): void;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        abstract etf$getItemsEquipped(): Internal.Iterable<Internal.ItemStack>;
        getSelectedSlot(): number;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        getOpenInventory(): Internal.AbstractContainerMenu;
        getXp(): number;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        setXp(xp: number): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        setCreativeMode(mode: boolean): void;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        isMiningBlock(): boolean;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        notify(builder: Notification_): void;
        isMonster(): boolean;
        sophisticatedCore_openMenu(menuProvider: Internal.MenuProvider_, pos: BlockPos_): Internal.OptionalInt;
        getType(): string;
        setChestArmorItem(item: Internal.ItemStack_): void;
        sophisticatedCore_openMenu(menu: Internal.MenuProvider_, context: Internal.Consumer_<Internal.FriendlyByteBuf>): Internal.OptionalInt;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        isCloseEnough(entity: Internal.Entity_, dist: number): boolean;
        getName(): net.minecraft.network.chat.Component;
        boostElytraFlight(): void;
        addExhaustion(exhaustion: number): void;
        getPassengers(): Internal.EntityArrayList;
        self(): Internal.ServerPlayer;
        giveInHand(item: Internal.ItemStack_): void;
        setMouseItem(item: Internal.ItemStack_): void;
        setTotalMovementSpeedMultiplier(speed: number): void;
        ban(banner: string, reason: string, expiresInMillis: number): void;
        sophisticatedInvalidateCaps(): void;
        sendData(channel: string, data: Internal.CompoundTag_): void;
        addXP(xp: number): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        static get(world: Internal.ServerLevel_): Internal.FakePlayer;
        give(item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        revokeAdvancement(id: ResourceLocation_): void;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getDigSpeed(state: Internal.BlockState_, pos: BlockPos_): number;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        spawn(): void;
        getMainHandItem(): Internal.ItemStack;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        kick(reason: net.minecraft.network.chat.Component_): void;
        canReach(entityHitVec: Vec3d_, padding: number): boolean;
        isAdvancementDone(id: ResourceLocation_): boolean;
        sendInventoryUpdate(): void;
        abstract etf$getHandItems(): Internal.Iterable<Internal.ItemStack>;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        unlockAdvancement(id: ResourceLocation_): void;
        getMouseItem(): Internal.ItemStack;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        openInventoryGUI(inventory: Internal.InventoryKJS_, title: net.minecraft.network.chat.Component_): void;
        getProfile(): Internal.GameProfile;
        getSaturation(): number;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        static getPlayerModelParts(): Internal.EntityDataAccessor<number>;
        addItemCooldown(item: Internal.Item_, ticks: number): void;
        get fake(): boolean
        get stats(): Internal.PlayerStatsJS
        set defaultMovementSpeedMultiplier(speed: number)
        get spawnLocation(): Internal.BlockContainerJS
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        set spawnLocation(c: Internal.BlockContainerJS_)
        get entityReach(): number
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get xpLevel(): number
        set selectedSlot(index: number)
        get living(): boolean
        get op(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get blockReach(): number
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        get animation(): Internal.AnimationApplier
        get foodLevel(): number
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        set xpLevel(l: number)
        set foodLevel(foodLevel: number)
        set saturation(saturation: number)
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get selectedSlot(): number
        get potionEffects(): Internal.EntityPotionEffectsJS
        get openInventory(): Internal.AbstractContainerMenu
        get xp(): number
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        set xp(xp: number)
        set creativeMode(mode: boolean)
        get defaultMovementSpeed(): number
        get miningBlock(): boolean
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set mouseItem(item: Internal.ItemStack_)
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        get mouseItem(): Internal.ItemStack
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        get saturation(): number
        set headArmorItem(item: Internal.ItemStack_)
        get playerModelParts(): Internal.EntityDataAccessor<number>
        static readonly DEFAULT_UUID: Internal.UUID;
    }
    type FakePlayer_ = FakePlayer;
    interface EmiRecipe {
        abstract getId(): ResourceLocation;
        abstract getInputs(): Internal.List<Internal.EmiIngredient>;
        supportsRecipeTree(): boolean;
        abstract getCategory(): Internal.EmiRecipeCategory;
        getCatalysts(): Internal.List<Internal.EmiIngredient>;
        abstract getDisplayWidth(): number;
        getBackingRecipe(): Internal.Recipe<any>;
        abstract getOutputs(): Internal.List<Internal.EmiStack>;
        hideCraftable(): boolean;
        abstract addWidgets(arg0: Internal.WidgetHolder_): void;
        abstract getDisplayHeight(): number;
        get id(): ResourceLocation
        get inputs(): Internal.List<Internal.EmiIngredient>
        get category(): Internal.EmiRecipeCategory
        get catalysts(): Internal.List<Internal.EmiIngredient>
        get displayWidth(): number
        get backingRecipe(): Internal.Recipe<any>
        get outputs(): Internal.List<Internal.EmiStack>
        get displayHeight(): number
    }
    type EmiRecipe_ = EmiRecipe;
    interface LongSupplier {
        abstract getAsLong(): number;
        get asLong(): number
        (): number;
    }
    type LongSupplier_ = LongSupplier;
    class StringIota$1 extends Internal.IotaType<Internal.StringIota> {
        deserialize(tag: Internal.Tag_, world: Internal.ServerLevel_): Internal.StringIota;
    }
    type StringIota$1_ = StringIota$1;
    class MediumFanBlock extends Internal.BaseFanBlock {
        constructor(settings: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type MediumFanBlock_ = MediumFanBlock;
    interface Char2FloatFunction extends Internal.IntToDoubleFunction, it.unimi.dsi.fastutil.Function<string, number> {
        andThenObject<T>(arg0: Internal.Float2ObjectFunction_<T>): Internal.Char2ObjectFunction<T>;
        /**
         * @deprecated
        */
        applyAsDouble(arg0: number): number;
        andThenFloat(arg0: Internal.Float2FloatFunction_): this;
        composeChar(arg0: Internal.Char2CharFunction_): this;
        /**
         * @deprecated
        */
        put(arg0: string, arg1: number): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        composeInt(arg0: Internal.Int2CharFunction_): Internal.Int2FloatFunction;
        composeReference<T>(arg0: Internal.Reference2CharFunction_<T>): Internal.Reference2FloatFunction<T>;
        composeFloat(arg0: Internal.Float2CharFunction_): Internal.Float2FloatFunction;
        composeLong(arg0: Internal.Long2CharFunction_): Internal.Long2FloatFunction;
        defaultReturnValue(arg0: number): void;
        containsKey(arg0: string): boolean;
        abstract get(arg0: string): number;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<string, T>;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        andThenChar(arg0: Internal.Float2CharFunction_): Internal.Char2CharFunction;
        composeShort(arg0: Internal.Short2CharFunction_): Internal.Short2FloatFunction;
        getOrDefault(arg0: string, arg1: number): number;
        andThenInt(arg0: Internal.Float2IntFunction_): Internal.Char2IntFunction;
        andThenLong(arg0: Internal.Float2LongFunction_): Internal.Char2LongFunction;
        composeDouble(arg0: Internal.Double2CharFunction_): Internal.Double2FloatFunction;
        defaultReturnValue(): number;
        composeObject<T>(arg0: Internal.Object2CharFunction_<T>): Internal.Object2FloatFunction<T>;
        andThenReference<T>(arg0: Internal.Float2ReferenceFunction_<T>): Internal.Char2ReferenceFunction<T>;
        remove(arg0: string): number;
        apply(arg0: string): number;
        andThenByte(arg0: Internal.Float2ByteFunction_): Internal.Char2ByteFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        andThenShort(arg0: Internal.Float2ShortFunction_): Internal.Char2ShortFunction;
        size(): number;
        composeByte(arg0: Internal.Byte2CharFunction_): Internal.Byte2FloatFunction;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, string>): Internal.Function<T, number>;
        clear(): void;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        put(arg0: string, arg1: number): number;
        andThenDouble(arg0: Internal.Float2DoubleFunction_): Internal.Char2DoubleFunction;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        identity<T>(): Internal.Function<T, T>;
        (arg0: string): number;
    }
    type Char2FloatFunction_ = Char2FloatFunction;
    abstract class ModuleReference {
        abstract open(): Internal.ModuleReader;
        location(): Internal.Optional<Internal.URI>;
        descriptor(): Internal.ModuleDescriptor;
    }
    type ModuleReference_ = ModuleReference;
    class ForgeConfigSpec$IntValue extends Internal.ForgeConfigSpec$ConfigValue<number> {
    }
    type ForgeConfigSpec$IntValue_ = ForgeConfigSpec$IntValue;
    class EnergyParticleData implements Internal.ParticleOptions {
        constructor(forItem: boolean, direction: Internal.Direction_)
        getType(): Internal.ParticleType<any>;
        writeToString(): string;
        writeToNetwork(buffer: Internal.FriendlyByteBuf_): void;
        get type(): Internal.ParticleType<any>
        static readonly FOR_BLOCK: Internal.EnergyParticleData;
        static readonly DESERIALIZER: Internal.ParticleOptions$Deserializer<Internal.EnergyParticleData>;
        readonly forItem: boolean;
        readonly direction: Internal.Direction;
    }
    type EnergyParticleData_ = EnergyParticleData;
    class MoldingRecipe$Serializer <T extends Internal.MoldingRecipe> extends Internal.LoggingRecipeSerializer<T> {
        constructor(factory: any_<T>)
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(id: ResourceLocation_, json: Internal.JsonObject_): T;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
    }
    type MoldingRecipe$Serializer_<T extends Internal.MoldingRecipe> = MoldingRecipe$Serializer<T>;
    class ManureFarmland extends Internal.Block {
        constructor(settings: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type ManureFarmland_ = ManureFarmland;
    interface IBearingBlockEntity extends Internal.IControlContraption {
        abstract setAngle(arg0: number): void;
        abstract attach(arg0: Internal.ControlledContraptionEntity_): void;
        abstract isValid(): boolean;
        getMovementModeSlot(): Internal.ValueBoxTransform;
        abstract onStall(): void;
        abstract isWoodenTop(): boolean;
        abstract getInterpolatedAngle(arg0: number): number;
        abstract getBlockPosition(): BlockPos;
        abstract isAttachedTo(arg0: Internal.AbstractContraptionEntity_): boolean;
        set angle(arg0: number)
        get valid(): boolean
        get movementModeSlot(): Internal.ValueBoxTransform
        get woodenTop(): boolean
        get blockPosition(): BlockPos
    }
    type IBearingBlockEntity_ = IBearingBlockEntity;
    class SearedDrainBlock extends Internal.RetexturedOrientableSmelteryBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type SearedDrainBlock_ = SearedDrainBlock;
    class FluidStack {
        constructor(copy: Internal.FluidStack_, amount: number)
        constructor(resource: any_<Internal.FluidVariant>)
        constructor(view: Internal.StorageView_<Internal.FluidVariant>)
        constructor(type: Internal.Fluid_, amount: number)
        constructor(type: Internal.FluidVariant_, amount: number)
        constructor(type: Internal.FluidVariant_, amount: number, tag: Internal.CompoundTag_)
        constructor(type: Internal.Fluid_, amount: number, nbt: Internal.CompoundTag_)
        getDisplayName(): net.minecraft.network.chat.Component;
        setTag(tag: Internal.CompoundTag_): void;
        static loadFluidStackFromNBT(tag: Internal.CompoundTag_): Internal.FluidStack;
        removeChildTag(key: string): void;
        isFluidEqual(other: Internal.FluidVariant_): boolean;
        isEmpty(): boolean;
        writeToNBT(nbt: Internal.CompoundTag_): Internal.CompoundTag;
        getAmount(): number;
        shrink(amount: number): void;
        static areFluidStackTagsEqual(stack1: Internal.FluidStack_, stack2: Internal.FluidStack_): boolean;
        static isFluidEqual(mine: Internal.FluidVariant_, other: Internal.FluidVariant_): boolean;
        isFluidEqual(other: Internal.FluidStack_): boolean;
        getType(): Internal.FluidVariant;
        isFluidStackIdentical(other: Internal.FluidStack_): boolean;
        static readFromPacket(buffer: Internal.FriendlyByteBuf_): Internal.FluidStack;
        containsFluid(other: Internal.FluidStack_): boolean;
        setAmount(amount: number): this;
        copy(): this;
        isFluidEqual(other: Internal.ItemStack_): boolean;
        shrink(amount: number): void;
        getOrCreateTag(): Internal.CompoundTag;
        canFill(var_: Internal.FluidVariant_): boolean;
        grow(amount: number): void;
        hasTag(): boolean;
        getTag(): Internal.CompoundTag;
        getFluid(): Internal.Fluid;
        writeToPacket(buffer: Internal.FriendlyByteBuf_): Internal.FriendlyByteBuf;
        get displayName(): net.minecraft.network.chat.Component
        set tag(tag: Internal.CompoundTag_)
        get empty(): boolean
        get amount(): number
        get type(): Internal.FluidVariant
        set amount(amount: number)
        get orCreateTag(): Internal.CompoundTag
        get tag(): Internal.CompoundTag
        get fluid(): Internal.Fluid
        static readonly EMPTY: Internal.FluidStack;
        static readonly CODEC: Internal.Codec<Internal.FluidStack>;
    }
    type FluidStack_ = FluidStack;
    interface IPartitionList {
        matchesFilter(key: Internal.AEKey_, mode: Internal.IncludeExclude_): boolean;
        builder(): Internal.IPartitionList$Builder;
        abstract getItems(): Internal.Iterable<Internal.AEKey>;
        abstract isEmpty(): boolean;
        abstract isListed(arg0: Internal.AEKey_): boolean;
        get items(): Internal.Iterable<Internal.AEKey>
        get empty(): boolean
    }
    type IPartitionList_ = IPartitionList;
    class FlashForgeEnchantment extends Internal.Enchantment {
        constructor()
        method_8180(other: Internal.Enchantment_): boolean;
        registryName(): string;
    }
    type FlashForgeEnchantment_ = FlashForgeEnchantment;
    class PressurePlateBlockBOP extends Internal.PressurePlateBlock {
        constructor($$2: Internal.BlockSetType_, $$1: Internal.BlockBehaviour$Properties_, $$0: any_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type PressurePlateBlockBOP_ = PressurePlateBlockBOP;
}
declare namespace io.github.fabricators_of_create.porting_lib.extensions.extensions {
    interface ItemExtensions {
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
    }
    type ItemExtensions_ = ItemExtensions;
}
declare namespace io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor {
    interface LivingEntityAccessor {
        abstract port_lib$getDeathSound(): Internal.SoundEvent;
        abstract port_lib$onEffectRemoved(arg0: Internal.MobEffectInstance_): void;
        abstract port_lib$isJumping(): boolean;
        abstract port_lib$lastPos(): BlockPos;
        abstract port_lib$spawnItemParticles(arg0: Internal.ItemStack_, arg1: number): void;
    }
    type LivingEntityAccessor_ = LivingEntityAccessor;
}
